/*
 * jQuery.floatnav.js
 *
 * Copyright (c) 2008 nori (norimania@gmail.com)
 * Licensed under the MIT
 * jQuery required (tested on 1.2.6)
 *
 * $Date: 2008-09-14 02:34
 */

jQuery.fn.floatNav = function(options){
	var subs = $("ul",this);
	var c = $.extend({
		left: "-70em",
		pos: "0",
		width: "auto",
		duration: "fast",
		easing: "swing",
		opacity: 1,
		timer: 0
	},options);
	$("li").hover(function(){$(this).addClass("hover")},function(){$(this).removeClass("hover")});
	subs.addClass("floatNav").each(function(){
		var sub = $(this);
		sub.css({
			width: c.width,
			top: c.pos,
			left: c.left,
			opacity: c.opacity
		}).mouseover(function(event){
			if(sub.css("left")!="0px") event.stopPropagation();
		}).parent().hover(function(){
			sub.animate(
				{left: 0},
				{duration: c.duration, easing: c.easing}
			);
		},function(event){
			setTimeout(function(){
				sub.animate(
					{left: c.left},
					{duration: c.duration, easing: c.easing}
				);
			},c.timer);
		});
	});
}