/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.LazyDynaMap;
import org.apache.commons.beanutils.PropertyUtils;

public class LazyDynaMapTestCase
extends TestCase {
    protected LazyDynaMap dynaMap;
    protected String testProperty = "myProperty";
    protected String testPropertyA = "myProperty-A";
    protected String testPropertyB = "myProperty-B";
    protected String testString1 = "myStringValue-1";
    protected String testString2 = "myStringValue-2";
    protected Integer testInteger1 = new Integer(30);
    protected Integer testInteger2 = new Integer(40);
    protected String testKey = "myKey";

    public static void main(String[] args) {
        TestRunner.run((Test)LazyDynaMapTestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(LazyDynaMapTestCase.class);
    }

    public LazyDynaMapTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.dynaMap = new LazyDynaMap();
        this.dynaMap.setReturnNull(true);
    }

    public void tearDown() {
        this.dynaMap = null;
    }

    public void testGeneral() {
        LazyDynaMapTestCase.assertEquals((String)"Check DynaClass name", (String)"TestBean", (String)new LazyDynaMap("TestBean").getName());
    }

    public void testIndexedDynaBeanArray() {
        int index = 3;
        LazyDynaBean[] objectArray = new LazyDynaBean[]{};
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.add(this.testProperty, objectArray.getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property exists", objectArray.getClass(), (Object)this.dynaMap.getDynaProperty(this.testProperty).getType());
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property is correct type", objectArray.getClass(), this.dynaMap.get(this.testProperty).getClass());
        for (int i = 3; i >= 0; --i) {
            LazyDynaMapTestCase.assertEquals((String)"Check Array Components initialized", LazyDynaBean.class, this.dynaMap.get(this.testProperty, 3).getClass());
        }
        this.dynaMap.add(this.testPropertyB, objectArray.getClass());
        LazyDynaBean newBean = new LazyDynaBean();
        newBean.set(this.testPropertyB, (Object)this.testString2);
        this.dynaMap.set(this.testPropertyA, 3, (Object)newBean);
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Value is correct(a)", (Object)this.testString2, (Object)((DynaBean)this.dynaMap.get(this.testPropertyA, 3)).get(this.testPropertyB));
    }

    public void testIndexedInvalidType() {
        int index = 3;
        this.dynaMap.set(this.testProperty, (Object)"Test String");
        LazyDynaMapTestCase.assertFalse((String)"Check Property is not indexed", (boolean)this.dynaMap.getDynaProperty(this.testProperty).isIndexed());
        try {
            this.dynaMap.set(this.testProperty, 3, (Object)this.testString1);
            LazyDynaMapTestCase.fail((String)"set(property, index, value) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIndexedLinkedList() {
        int index = 3;
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.add(this.testProperty, LinkedList.class);
        LazyDynaMapTestCase.assertTrue((String)"Check Property is indexed", (boolean)this.dynaMap.getDynaProperty(this.testProperty).isIndexed());
        LazyDynaMapTestCase.assertEquals((String)"Check Property is correct type", LinkedList.class, (Object)this.dynaMap.getDynaProperty(this.testProperty).getType());
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property now exists", LinkedList.class, this.dynaMap.get(this.testProperty).getClass());
        this.dynaMap.set(this.testProperty, index, (Object)this.testString1);
        LazyDynaMapTestCase.assertEquals((String)"Check Property type is correct", LinkedList.class, this.dynaMap.get(this.testProperty).getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check First Indexed Value is correct", (Object)this.testString1, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check First Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((LinkedList)this.dynaMap.get(this.testProperty)).size()));
        this.dynaMap.set(this.testProperty, index += 2, (Object)this.testInteger1);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Indexed Value is correct", (Object)this.testInteger1, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((LinkedList)this.dynaMap.get(this.testProperty)).size()));
    }

    public void testIndexedObjectArray() {
        int index = 3;
        String[] objectArray = new String[]{};
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.add(this.testProperty, objectArray.getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property exists", objectArray.getClass(), (Object)this.dynaMap.getDynaProperty(this.testProperty).getType());
        LazyDynaMapTestCase.assertTrue((String)"Check Indexed Property exists", (boolean)this.dynaMap.get(this.testProperty).getClass().isInstance(objectArray));
        this.dynaMap.set(this.testProperty, index, (Object)this.testString1);
        LazyDynaMapTestCase.assertNotNull((String)"Check Indexed Property is not null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property is correct type", objectArray.getClass(), this.dynaMap.get(this.testProperty).getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check First Indexed Value is correct(a)", (Object)this.testString1, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check First Indexed Value is correct(b)", (String)this.testString1, (String)((String[])this.dynaMap.get(this.testProperty))[index]);
        LazyDynaMapTestCase.assertEquals((String)"Check Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((String[])this.dynaMap.get(this.testProperty)).length));
        this.dynaMap.set(this.testProperty, index += 2, (Object)this.testString2);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Indexed Value is correct(a)", (Object)this.testString2, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Indexed Value is correct(b)", (String)this.testString2, (String)((String[])this.dynaMap.get(this.testProperty))[index]);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((String[])this.dynaMap.get(this.testProperty)).length));
    }

    public void testIndexedPrimitiveArray() {
        int index = 3;
        int[] primitiveArray = new int[]{};
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.add(this.testProperty, primitiveArray.getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property exists", primitiveArray.getClass(), (Object)this.dynaMap.getDynaProperty(this.testProperty).getType());
        LazyDynaMapTestCase.assertTrue((String)"Check Indexed Property exists", (boolean)this.dynaMap.get(this.testProperty).getClass().isInstance(primitiveArray));
        this.dynaMap.set(this.testProperty, index, (Object)this.testInteger1);
        LazyDynaMapTestCase.assertNotNull((String)"Check Indexed Property is not null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property is correct type", primitiveArray.getClass(), this.dynaMap.get(this.testProperty).getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check First Indexed Value is correct(a)", (Object)this.testInteger1, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check First Indexed Value is correct(b)", (Object)this.testInteger1, (Object)new Integer(((int[])this.dynaMap.get(this.testProperty))[index]));
        LazyDynaMapTestCase.assertEquals((String)"Check Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((int[])this.dynaMap.get(this.testProperty)).length));
        this.dynaMap.set(this.testProperty, index += 2, (Object)this.testInteger2);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Indexed Value is correct(a)", (Object)this.testInteger2, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Indexed Value is correct(b)", (Object)this.testInteger2, (Object)new Integer(((int[])this.dynaMap.get(this.testProperty))[index]));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((int[])this.dynaMap.get(this.testProperty)).length));
    }

    public void testIndexedPropertyDefault() {
        int index = 3;
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed value is null", (Object)this.dynaMap.get(this.testProperty, index));
        this.dynaMap.set(this.testProperty, index, (Object)this.testInteger1);
        LazyDynaMapTestCase.assertNotNull((String)"Check Indexed Property is not null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Property is correct type", ArrayList.class, this.dynaMap.get(this.testProperty).getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check First Indexed Value is correct", (Object)this.testInteger1, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check First Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((ArrayList)this.dynaMap.get(this.testProperty)).size()));
        this.dynaMap.set(this.testProperty, index += 2, (Object)this.testString1);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Indexed Value is correct", (Object)this.testString1, (Object)this.dynaMap.get(this.testProperty, index));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Array length is correct", (Object)new Integer(index + 1), (Object)new Integer(((ArrayList)this.dynaMap.get(this.testProperty)).size()));
    }

    public void testIndexedPropertyRestricted() {
        int index = 3;
        this.dynaMap.setRestricted(true);
        LazyDynaMapTestCase.assertTrue((String)"Check MutableDynaClass is restricted", (boolean)this.dynaMap.isRestricted());
        LazyDynaMapTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Value is null", (Object)this.dynaMap.get(this.testProperty));
        try {
            this.dynaMap.set(this.testProperty, 3, (Object)this.testInteger1);
            LazyDynaMapTestCase.fail((String)"expected IllegalArgumentException trying to add new property to restricted MutableDynaClass");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIndexedPropertyUtils() {
        int index = 3;
        this.dynaMap.setReturnNull(false);
        LazyDynaMapTestCase.assertFalse((String)"Check Indexed Property doesn't exist", (boolean)this.dynaMap.isDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Indexed value is null", (Object)this.dynaMap.get(this.testProperty, 3));
        try {
            PropertyUtils.setProperty((Object)this.dynaMap, (String)(this.testProperty + "[" + 3 + "]"), (Object)this.testString1);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LazyDynaMapTestCase.fail((String)("testIndexedPropertyUtils threw " + ex));
        }
        LazyDynaMapTestCase.assertEquals((String)"Check Indexed Bean Value is correct", (Object)this.testString1, (Object)this.dynaMap.get(this.testProperty, 3));
    }

    public void testMappedInvalidType() {
        this.dynaMap.set(this.testProperty, (Object)new Integer(1));
        LazyDynaMapTestCase.assertFalse((String)"Check Property is not mapped", (boolean)this.dynaMap.getDynaProperty(this.testProperty).isMapped());
        try {
            this.dynaMap.set(this.testProperty, this.testKey, (Object)this.testInteger1);
            LazyDynaMapTestCase.fail((String)"set(property, key, value) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappedPropertyDefault() {
        LazyDynaMapTestCase.assertNull((String)"Check Mapped Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Map is null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Mapped Value is null", (Object)this.dynaMap.get(this.testProperty, this.testKey));
        this.dynaMap.set(this.testProperty, this.testKey, (Object)this.testInteger1);
        LazyDynaMapTestCase.assertEquals((String)"Check Mapped Property exists", HashMap.class, this.dynaMap.get(this.testProperty).getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check First Mapped Value is correct(a)", (Object)this.testInteger1, (Object)this.dynaMap.get(this.testProperty, this.testKey));
        LazyDynaMapTestCase.assertEquals((String)"Check First Mapped Value is correct(b)", (Object)this.testInteger1, ((HashMap)this.dynaMap.get(this.testProperty)).get(this.testKey));
        this.dynaMap.set(this.testProperty, this.testKey, (Object)this.testInteger2);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Mapped Value is correct(a)", (Object)this.testInteger2, (Object)this.dynaMap.get(this.testProperty, this.testKey));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Mapped Value is correct(b)", (Object)this.testInteger2, ((HashMap)this.dynaMap.get(this.testProperty)).get(this.testKey));
    }

    public void testMappedPropertyRestricted() {
        this.dynaMap.setRestricted(true);
        LazyDynaMapTestCase.assertTrue((String)"Check MutableDynaClass is restricted", (boolean)this.dynaMap.isRestricted());
        LazyDynaMapTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Value is null", (Object)this.dynaMap.get(this.testProperty));
        try {
            this.dynaMap.set(this.testProperty, this.testKey, (Object)this.testInteger1);
            LazyDynaMapTestCase.fail((String)"expected IllegalArgumentException trying to add new property to restricted MutableDynaClass");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappedPropertyTreeMap() {
        LazyDynaMapTestCase.assertNull((String)"Check Mapped Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Map is null", (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.add(this.testProperty, TreeMap.class);
        LazyDynaMapTestCase.assertTrue((String)"Check Property is mapped", (boolean)this.dynaMap.getDynaProperty(this.testProperty).isMapped());
        LazyDynaMapTestCase.assertEquals((String)"Check Property is correct type", TreeMap.class, (Object)this.dynaMap.getDynaProperty(this.testProperty).getType());
        LazyDynaMapTestCase.assertEquals((String)"Check Mapped Property now exists", TreeMap.class, this.dynaMap.get(this.testProperty).getClass());
        this.dynaMap.set(this.testProperty, this.testKey, (Object)this.testInteger1);
        LazyDynaMapTestCase.assertEquals((String)"Check Mapped Property exists", TreeMap.class, this.dynaMap.get(this.testProperty).getClass());
        LazyDynaMapTestCase.assertEquals((String)"Check First Mapped Value is correct(a)", (Object)this.testInteger1, (Object)this.dynaMap.get(this.testProperty, this.testKey));
        LazyDynaMapTestCase.assertEquals((String)"Check First Mapped Value is correct(b)", (Object)this.testInteger1, ((TreeMap)this.dynaMap.get(this.testProperty)).get(this.testKey));
        this.dynaMap.set(this.testProperty, this.testKey, (Object)this.testInteger2);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Mapped Value is correct(a)", (Object)this.testInteger2, (Object)this.dynaMap.get(this.testProperty, this.testKey));
        LazyDynaMapTestCase.assertEquals((String)"Check Second Mapped Value is correct(b)", (Object)this.testInteger2, ((TreeMap)this.dynaMap.get(this.testProperty)).get(this.testKey));
    }

    public void testMappedPropertyUtils() {
        this.dynaMap.setReturnNull(false);
        LazyDynaMapTestCase.assertFalse((String)"Check Mapped Property doesn't exist", (boolean)this.dynaMap.isDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Map is null", (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Mapped Value is null", (Object)this.dynaMap.get(this.testProperty, this.testKey));
        try {
            PropertyUtils.setProperty((Object)this.dynaMap, (String)(this.testProperty + "(" + this.testKey + ")"), (Object)this.testString1);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LazyDynaMapTestCase.fail((String)("testIndexedPropertyUtils threw " + ex));
        }
        LazyDynaMapTestCase.assertEquals((String)"Check Mapped Bean Value is correct", (Object)this.testString1, (Object)this.dynaMap.get(this.testProperty, this.testKey));
    }

    public void testNewInstance() {
        LazyDynaMap orig = new LazyDynaMap(new TreeMap());
        orig.set("indexProp", 0, (Object)"indexVal0");
        orig.set("indexProp", 1, (Object)"indexVal1");
        LazyDynaMapTestCase.assertEquals((String)"Index prop size", (int)2, (int)((List)orig.get("indexProp")).size());
        LazyDynaMap newOne = (LazyDynaMap)orig.newInstance();
        Map newMap = newOne.getMap();
        LazyDynaMapTestCase.assertEquals((String)"Check Map type", TreeMap.class, newMap.getClass());
        ArrayList indexProp = (ArrayList)newMap.get("indexProp");
        LazyDynaMapTestCase.assertNotNull((String)"Indexed Prop missing", (Object)indexProp);
        LazyDynaMapTestCase.assertEquals((String)"Index prop size", (int)0, (int)indexProp.size());
    }

    public void testSimpleProperty() {
        LazyDynaMapTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Value is null", (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.set(this.testProperty, (Object)this.testInteger1);
        LazyDynaMapTestCase.assertEquals((String)"Check First Value is correct", (Object)this.testInteger1, (Object)this.dynaMap.get(this.testProperty));
        LazyDynaMapTestCase.assertEquals((String)"Check Property type is correct", Integer.class, (Object)this.dynaMap.getDynaProperty(this.testProperty).getType());
        this.dynaMap.set(this.testProperty, (Object)this.testInteger2);
        LazyDynaMapTestCase.assertEquals((String)"Check Second Value is correct", (Object)this.testInteger2, (Object)this.dynaMap.get(this.testProperty));
        this.dynaMap.set(this.testProperty, (Object)this.testString1);
        LazyDynaMapTestCase.assertEquals((String)"Check Third Value is correct", (Object)this.testString1, (Object)this.dynaMap.get(this.testProperty));
    }

    public void testSimplePropertyRestricted() {
        this.dynaMap.setRestricted(true);
        LazyDynaMapTestCase.assertTrue((String)"Check MutableDynaClass is restricted", (boolean)this.dynaMap.isRestricted());
        LazyDynaMapTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaMap.getDynaProperty(this.testProperty));
        LazyDynaMapTestCase.assertNull((String)"Check Value is null", (Object)this.dynaMap.get(this.testProperty));
        try {
            this.dynaMap.set(this.testProperty, (Object)this.testString1);
            LazyDynaMapTestCase.fail((String)"expected IllegalArgumentException trying to add new property to restricted DynaClass");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

