/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.junit.Assert;
import org.junit.Test;

public class Jira541TestCase {
    private static final String FIELD_NAME = "field";
    private static final String FIELD_VALUE = "name";

    @Test
    public void testFluentBeanIntrospectorOnOverriddenSetter() throws Exception {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        propertyUtilsBean.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        SubTypeA subTypeA = new SubTypeA();
        propertyUtilsBean.setProperty((Object)subTypeA, FIELD_NAME, (Object)FIELD_VALUE);
        SubTypeB subTypeB = new SubTypeB();
        propertyUtilsBean.setProperty((Object)subTypeB, FIELD_NAME, (Object)FIELD_VALUE);
        Assert.assertEquals((Object)FIELD_VALUE, (Object)subTypeA.getField());
        Assert.assertEquals((Object)FIELD_VALUE, (Object)subTypeB.getField());
    }

    public static class SubTypeA
    extends BaseType {
        @Override
        public SubTypeA setField(String field) {
            super.setField(field);
            return this;
        }
    }

    public static class SubTypeB
    extends BaseType {
    }

    public static class BaseType {
        private String field;

        public String getField() {
            return this.field;
        }

        public BaseType setField(String objectName) {
            this.field = objectName;
            return this;
        }
    }
}

