/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.bugs.other.Jira18BeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jira18TestCase
extends TestCase {
    private final Log log = LogFactory.getLog(Jira18TestCase.class);
    private Object bean;

    public Jira18TestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Jira18TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira18TestCase.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = Jira18BeanFactory.createBean();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_isReadable() {
        boolean result = false;
        try {
            result = PropertyUtils.isReadable((Object)this.bean, (String)"simple");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertFalse((String)"PropertyUtils.isReadable(bean, \"simple\") returned true", (boolean)result);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_isWriteable() {
        boolean result = false;
        try {
            result = PropertyUtils.isWriteable((Object)this.bean, (String)"simple");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertFalse((String)"PropertyUtils.isWriteable(bean, \"simple\") returned true", (boolean)result);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_isReadable_Indexed() {
        boolean result = false;
        try {
            result = PropertyUtils.isReadable((Object)this.bean, (String)"indexed");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertFalse((String)"PropertyUtils.isReadable(bean, \"indexed\") returned true", (boolean)result);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_isWriteable_Indexed() {
        boolean result = false;
        try {
            result = PropertyUtils.isWriteable((Object)this.bean, (String)"indexed");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertFalse((String)"PropertyUtils.isWriteable(bean, \"indexed\") returned true", (boolean)result);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_isReadable_Mapped() {
        boolean result = false;
        try {
            result = PropertyUtils.isReadable((Object)this.bean, (String)"mapped");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertFalse((String)"PropertyUtils.isReadable(bean, \"mapped\") returned true", (boolean)result);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_isWriteable_Mapped() {
        boolean result = false;
        try {
            result = PropertyUtils.isWriteable((Object)this.bean, (String)"mapped");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertFalse((String)"PropertyUtils.isWriteable(bean, \"mapped\") returned true", (boolean)result);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_getProperty() {
        boolean threwNoSuchMethodException = false;
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)this.bean, (String)"simple");
        }
        catch (NoSuchMethodException ex) {
            threwNoSuchMethodException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertTrue((String)("Expected NoSuchMethodException but returned '" + result + "'"), (boolean)threwNoSuchMethodException);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_setProperty() {
        boolean threwNoSuchMethodException = false;
        try {
            PropertyUtils.setProperty((Object)this.bean, (String)"simple", (Object)"BAR");
        }
        catch (NoSuchMethodException ex) {
            threwNoSuchMethodException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertTrue((String)"Expected NoSuchMethodException", (boolean)threwNoSuchMethodException);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_getProperty_Indexed() {
        boolean threwNoSuchMethodException = false;
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)this.bean, (String)"indexed[0]");
        }
        catch (NoSuchMethodException ex) {
            threwNoSuchMethodException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertTrue((String)("Expected NoSuchMethodException but returned '" + result + "'"), (boolean)threwNoSuchMethodException);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_setProperty_Indexed() {
        boolean threwNoSuchMethodException = false;
        try {
            PropertyUtils.setProperty((Object)this.bean, (String)"indexed[0]", (Object)"BAR");
        }
        catch (NoSuchMethodException ex) {
            threwNoSuchMethodException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertTrue((String)"Expected NoSuchMethodException", (boolean)threwNoSuchMethodException);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_getProperty_Mapped() {
        boolean threwNoSuchMethodException = false;
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)this.bean, (String)"mapped(foo-key)");
        }
        catch (NoSuchMethodException ex) {
            threwNoSuchMethodException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertTrue((String)("Expected NoSuchMethodException but returned '" + result + "'"), (boolean)threwNoSuchMethodException);
    }

    public void testIssue_BEANUTILS_18_PropertyUtils_setProperty_Mapped() {
        boolean threwNoSuchMethodException = false;
        try {
            PropertyUtils.setProperty((Object)this.bean, (String)"mapped(foo-key)", (Object)"BAR");
        }
        catch (NoSuchMethodException ex) {
            threwNoSuchMethodException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira18TestCase.fail((String)("Threw exception: " + t));
        }
        Jira18TestCase.assertTrue((String)"Expected NoSuchMethodException", (boolean)threwNoSuchMethodException);
    }
}

