/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.BenchBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class BeanUtilsBenchCase
extends TestCase {
    private long counter = 100000L;
    private DynaClass dynaClass = null;
    private BenchBean inBean = null;
    private DynaBean inDyna = null;
    private Map<String, Object> inMap = null;
    private Map<String, String> inStrs = null;
    private BenchBean outBean = null;
    private DynaBean outDyna = null;
    private BeanUtilsBean bu = null;

    public BeanUtilsBenchCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        String prop = System.getProperty("counter");
        if (prop != null) {
            this.counter = Long.parseLong(prop);
        }
        this.dynaClass = new BasicDynaClass("BenchDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("byteProperty", Byte.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringProperty", String.class)});
        this.inBean = new BenchBean();
        this.inMap = new HashMap<String, Object>();
        this.inMap.put("booleanProperty", new Boolean(this.inBean.getBooleanProperty()));
        this.inMap.put("byteProperty", new Byte(this.inBean.getByteProperty()));
        this.inMap.put("doubleProperty", new Double(this.inBean.getDoubleProperty()));
        this.inMap.put("floatProperty", new Float(this.inBean.getFloatProperty()));
        this.inMap.put("intProperty", new Integer(this.inBean.getIntProperty()));
        this.inMap.put("longProperty", new Long(this.inBean.getLongProperty()));
        this.inMap.put("shortProperty", new Short(this.inBean.getShortProperty()));
        this.inMap.put("stringProperty", this.inBean.getStringProperty());
        this.inDyna = this.dynaClass.newInstance();
        for (String inKey : this.inMap.keySet()) {
            this.inDyna.set(inKey, this.inMap.get(inKey));
        }
        this.inStrs = new HashMap<String, String>();
        for (String inKey : this.inMap.keySet()) {
            this.inStrs.put(inKey, this.inMap.get(inKey).toString());
        }
        this.outBean = new BenchBean();
        this.outDyna = this.dynaClass.newInstance();
        for (String outKey : this.inMap.keySet()) {
            this.outDyna.set(outKey, this.inMap.get(outKey));
        }
        this.bu = BeanUtilsBean.getInstance();
    }

    public static Test suite() {
        return new TestSuite(BeanUtilsBenchCase.class);
    }

    public void tearDown() {
        this.dynaClass = null;
        this.inBean = null;
        this.inDyna = null;
        this.inMap = null;
        this.outBean = null;
        this.outDyna = null;
        this.bu = null;
    }

    public void testCopyPropertiesBean() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inBean);
        }
        long start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inBean);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean,bean), count=" + this.counter + ", time=" + (stop - start));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inBean);
        }
        start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inBean);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna,bean), count=" + this.counter + ", time=" + (stop - start));
    }

    public void testCopyPropertiesDyna() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inDyna);
        }
        long start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inDyna);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean,dyna), count=" + this.counter + ", time=" + (stop - start));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inDyna);
        }
        start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inDyna);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna,dyna), count=" + this.counter + ", time=" + (stop - start));
    }

    public void testCopyPropertiesMap() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inMap);
        }
        long start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inMap);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean, map), count=" + this.counter + ", time=" + (stop - start));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inMap);
        }
        start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inMap);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna, map), count=" + this.counter + ", time=" + (stop - start));
    }

    public void testCopyPropertiesStrs() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inStrs);
        }
        long start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inStrs);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean,strs), count=" + this.counter + ", time=" + (stop - start));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inStrs);
        }
        start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inStrs);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna,strs), count=" + this.counter + ", time=" + (stop - start));
    }

    public void testPopulateMap() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inMap);
        }
        long start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inMap);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.populate(bean, map), count=" + this.counter + ", time=" + (stop - start));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inMap);
        }
        start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inMap);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.populate(dyna, map), count=" + this.counter + ", time=" + (stop - start));
    }

    public void testPopulateStrs() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inStrs);
        }
        long start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inStrs);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.populate(bean,strs), count=" + this.counter + ", time=" + (stop - start));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inStrs);
        }
        start = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inStrs);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.populate(dyna,strs), count=" + this.counter + ", time=" + (stop - start));
    }
}

