/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanUtilsTestCase;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.MappedPropertyTestBean;
import org.apache.commons.beanutils.PassTestException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.beanutils.ThrowExceptionConverter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.DateConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsTestCase
extends TestCase {
    protected TestBean bean = null;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "byteProperty", "doubleProperty", "dupProperty", "floatProperty", "intArray", "longProperty", "listIndexed", "longProperty", "nested", "nullProperty", "readOnlyProperty", "shortProperty", "stringArray", "stringProperty"};
    protected Calendar testCalendar;
    protected Date testUtilDate;
    protected String testStringDate;

    public BeanUtilsTestCase(String name) {
        super(name);
    }

    public void setUp() {
        ConvertUtils.deregister();
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean());
        this.setUpShared();
    }

    protected void setUpShared() {
        this.bean = new TestBean();
        DateConverter dateConverter = new DateConverter(null);
        dateConverter.setLocale(Locale.US);
        dateConverter.setPattern("dd.MM.yyyy");
        ConvertUtils.register((Converter)dateConverter, Date.class);
        ArrayConverter dateArrayConverter = new ArrayConverter(Date[].class, (Converter)dateConverter, 0);
        ConvertUtils.register((Converter)dateArrayConverter, Date[].class);
        this.testCalendar = Calendar.getInstance();
        this.testCalendar.set(1992, 11, 28, 0, 0, 0);
        this.testCalendar.set(14, 0);
        this.testUtilDate = this.testCalendar.getTime();
        this.testStringDate = "28.12.1992";
    }

    public static Test suite() {
        return new TestSuite(BeanUtilsTestCase.class);
    }

    public void tearDown() {
        this.bean = null;
    }

    public void testCopyPropertiesDynaBean() {
        DynaClass dynaClass = DynaBeanUtilsTestCase.createDynaClass();
        DynaBean orig = null;
        try {
            orig = dynaClass.newInstance();
        }
        catch (Exception e) {
            BeanUtilsTestCase.fail((String)("newInstance(): " + e));
        }
        orig.set("booleanProperty", (Object)Boolean.FALSE);
        orig.set("byteProperty", (Object)new Byte(111));
        orig.set("doubleProperty", (Object)new Double(333.33));
        orig.set("dupProperty", (Object)new String[]{"New 0", "New 1", "New 2"});
        orig.set("intArray", (Object)new int[]{100, 200, 300});
        orig.set("intProperty", (Object)new Integer(333));
        orig.set("longProperty", (Object)new Long(3333L));
        orig.set("shortProperty", (Object)new Short(33));
        orig.set("stringArray", (Object)new String[]{"New 0", "New 1"});
        orig.set("stringProperty", (Object)"Custom string");
        try {
            BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        }
        catch (Exception e) {
            BeanUtilsTestCase.fail((String)("Threw exception: " + e));
        }
        BeanUtilsTestCase.assertEquals((String)"Copied boolean property", (boolean)false, (boolean)this.bean.getBooleanProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied byte property", (byte)111, (byte)this.bean.getByteProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied double property", (double)333.33, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtilsTestCase.assertEquals((String)"Copied int property", (int)333, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied long property", (long)3333L, (long)this.bean.getLongProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied short property", (short)33, (short)this.bean.getShortProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied string property", (String)"Custom string", (String)this.bean.getStringProperty());
        String[] dupProperty = this.bean.getDupProperty();
        BeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        BeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = this.bean.getIntArray();
        BeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        BeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        BeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)100, (int)intArray[0]);
        BeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)200, (int)intArray[1]);
        BeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)300, (int)intArray[2]);
        String[] stringArray = this.bean.getStringArray();
        BeanUtilsTestCase.assertNotNull((String)"stringArray present", (Object)stringArray);
        BeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
        BeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New 0", (String)stringArray[0]);
        BeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New 1", (String)stringArray[1]);
    }

    public void testCopyPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", "false");
        map.put("byteProperty", "111");
        map.put("doubleProperty", "333.0");
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", "222.0");
        map.put("intArray", new String[]{"0", "100", "200"});
        map.put("intProperty", "111");
        map.put("longProperty", "444");
        map.put("shortProperty", "555");
        map.put("stringProperty", "New String Property");
        try {
            BeanUtils.copyProperties((Object)this.bean, map);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t.toString()));
        }
        BeanUtilsTestCase.assertEquals((String)"booleanProperty", (boolean)false, (boolean)this.bean.getBooleanProperty());
        BeanUtilsTestCase.assertEquals((String)"byteProperty", (byte)111, (byte)this.bean.getByteProperty());
        BeanUtilsTestCase.assertEquals((String)"doubleProperty", (double)333.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtilsTestCase.assertEquals((String)"floatProperty", (float)222.0f, (float)this.bean.getFloatProperty(), (float)0.005f);
        BeanUtilsTestCase.assertEquals((String)"longProperty", (int)111, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((String)"longProperty", (long)444L, (long)this.bean.getLongProperty());
        BeanUtilsTestCase.assertEquals((String)"shortProperty", (short)555, (short)this.bean.getShortProperty());
        BeanUtilsTestCase.assertEquals((String)"stringProperty", (String)"New String Property", (String)this.bean.getStringProperty());
        String[] dupProperty = this.bean.getDupProperty();
        BeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        BeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = this.bean.getIntArray();
        BeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        BeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        BeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)0, (int)intArray[0]);
        BeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)100, (int)intArray[1]);
        BeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)200, (int)intArray[2]);
    }

    public void testCopyPropertiesStandard() {
        TestBean orig = new TestBean();
        orig.setBooleanProperty(false);
        orig.setByteProperty((byte)111);
        orig.setDoubleProperty(333.33);
        orig.setDupProperty(new String[]{"New 0", "New 1", "New 2"});
        orig.setIntArray(new int[]{100, 200, 300});
        orig.setIntProperty(333);
        orig.setLongProperty(3333L);
        orig.setShortProperty((short)33);
        orig.setStringArray(new String[]{"New 0", "New 1"});
        orig.setStringProperty("Custom string");
        try {
            BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        }
        catch (Exception e) {
            BeanUtilsTestCase.fail((String)("Threw exception: " + e));
        }
        BeanUtilsTestCase.assertEquals((String)"Copied boolean property", (boolean)false, (boolean)this.bean.getBooleanProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied byte property", (byte)111, (byte)this.bean.getByteProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied double property", (double)333.33, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtilsTestCase.assertEquals((String)"Copied int property", (int)333, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied long property", (long)3333L, (long)this.bean.getLongProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied short property", (short)33, (short)this.bean.getShortProperty());
        BeanUtilsTestCase.assertEquals((String)"Copied string property", (String)"Custom string", (String)this.bean.getStringProperty());
        String[] dupProperty = this.bean.getDupProperty();
        BeanUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        BeanUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        BeanUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = this.bean.getIntArray();
        BeanUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        BeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        BeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)100, (int)intArray[0]);
        BeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)200, (int)intArray[1]);
        BeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)300, (int)intArray[2]);
        String[] stringArray = this.bean.getStringArray();
        BeanUtilsTestCase.assertNotNull((String)"stringArray present", (Object)stringArray);
        BeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
        BeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New 0", (String)stringArray[0]);
        BeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New 1", (String)stringArray[1]);
    }

    public void testDescribe() {
        Map map = null;
        try {
            map = BeanUtils.describe((Object)this.bean);
        }
        catch (Exception e) {
            BeanUtilsTestCase.fail((String)("Threw exception " + e));
        }
        for (int i = 0; i < this.describes.length; ++i) {
            BeanUtilsTestCase.assertTrue((String)("Property '" + this.describes[i] + "' is present"), (boolean)map.containsKey(this.describes[i]));
        }
        BeanUtilsTestCase.assertTrue((String)"Property 'writeOnlyProperty' is not present", (!map.containsKey("writeOnlyProperty") ? 1 : 0) != 0);
        BeanUtilsTestCase.assertEquals((String)"Value of 'booleanProperty'", (String)"true", (String)((String)map.get("booleanProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'byteProperty'", (String)"121", (String)((String)map.get("byteProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'doubleProperty'", (String)"321.0", (String)((String)map.get("doubleProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'floatProperty'", (String)"123.0", (String)((String)map.get("floatProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'intProperty'", (String)"123", (String)((String)map.get("intProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'longProperty'", (String)"321", (String)((String)map.get("longProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'shortProperty'", (String)"987", (String)((String)map.get("shortProperty")));
        BeanUtilsTestCase.assertEquals((String)"Value of 'stringProperty'", (String)"This is a string", (String)((String)map.get("stringProperty")));
    }

    public void testGetArrayProperty() {
        try {
            String[] arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"stringArray");
            String[] comp = this.bean.getStringArray();
            BeanUtilsTestCase.assertTrue((String)("String array length = " + comp.length), (comp.length == arr.length ? 1 : 0) != 0);
            arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"intArray");
            int[] iarr = this.bean.getIntArray();
            BeanUtilsTestCase.assertTrue((String)("String array length = " + iarr.length), (iarr.length == arr.length ? 1 : 0) != 0);
            arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"shortProperty");
            String shortAsString = "" + this.bean.getShortProperty();
            BeanUtilsTestCase.assertEquals((String)"Short List Test lth", (int)1, (int)arr.length);
            BeanUtilsTestCase.assertEquals((String)"Short Test value", (String)shortAsString, (String)arr[0]);
            this.bean.setStringProperty("ABC");
            arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"stringProperty");
            BeanUtilsTestCase.assertEquals((String)"Delimited List Test lth", (int)1, (int)arr.length);
            BeanUtilsTestCase.assertEquals((String)"Delimited List Test value1", (String)"ABC", (String)arr[0]);
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            BeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetArrayPropertyDate() {
        String[] value = null;
        try {
            this.bean.setDateArrayProperty(new Date[]{this.testUtilDate});
            value = BeanUtils.getArrayProperty((Object)this.bean, (String)"dateArrayProperty");
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)value.length);
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testUtilDate.toString(), (String)value[0]);
    }

    public void testGetIndexedProperty1() {
        try {
            String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
            String comp = String.valueOf(this.bean.getIntIndexed(3));
            BeanUtilsTestCase.assertTrue((String)("intIndexed[3] == " + comp), (boolean)val.equals(comp));
            val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed[3]");
            comp = this.bean.getStringIndexed(3);
            BeanUtilsTestCase.assertTrue((String)("stringIndexed[3] == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            BeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetIndexedPropertyDate() {
        String value = null;
        try {
            this.bean.setDateArrayProperty(new Date[]{this.testUtilDate});
            value = BeanUtils.getIndexedProperty((Object)this.bean, (String)"dateArrayProperty[0]");
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[0] --> String", (String)this.testUtilDate.toString(), (String)value);
    }

    public void testGetIndexedProperty2() {
        try {
            String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)3);
            String comp = String.valueOf(this.bean.getIntIndexed(3));
            BeanUtilsTestCase.assertTrue((String)("intIndexed,3 == " + comp), (boolean)val.equals(comp));
            val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)3);
            comp = this.bean.getStringIndexed(3);
            BeanUtilsTestCase.assertTrue((String)("stringIndexed,3 == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            BeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedProperty() {
        try {
            String val = BeanUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
            String comp = this.bean.getNested().getStringProperty();
            BeanUtilsTestCase.assertTrue((String)("nested.StringProperty == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            BeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetGeneralProperty() {
        try {
            String val = BeanUtils.getProperty((Object)this.bean, (String)"nested.intIndexed[2]");
            String comp = String.valueOf(this.bean.getIntIndexed(2));
            BeanUtilsTestCase.assertTrue((String)("nested.intIndexed[2] == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            BeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleProperty() {
        try {
            String val = BeanUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
            String comp = String.valueOf(this.bean.getShortProperty());
            BeanUtilsTestCase.assertTrue((String)("shortProperty == " + comp), (boolean)val.equals(comp));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            BeanUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimplePropertyDate() {
        String value = null;
        try {
            this.bean.setDateProperty(this.testUtilDate);
            value = BeanUtils.getSimpleProperty((Object)this.bean, (String)"dateProperty");
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date --> String", (String)this.testUtilDate.toString(), (String)value);
    }

    public void testPopulateArrayElements() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("intIndexed[0]", "100");
            map.put("intIndexed[2]", "120");
            map.put("intIndexed[4]", "140");
            BeanUtils.populate((Object)this.bean, map);
            BeanUtilsTestCase.assertEquals((String)"intIndexed[0] is 100", (int)100, (int)this.bean.getIntIndexed(0));
            BeanUtilsTestCase.assertEquals((String)"intIndexed[1] is 10", (int)10, (int)this.bean.getIntIndexed(1));
            BeanUtilsTestCase.assertEquals((String)"intIndexed[2] is 120", (int)120, (int)this.bean.getIntIndexed(2));
            BeanUtilsTestCase.assertEquals((String)"intIndexed[3] is 30", (int)30, (int)this.bean.getIntIndexed(3));
            BeanUtilsTestCase.assertEquals((String)"intIndexed[4] is 140", (int)140, (int)this.bean.getIntIndexed(4));
            map.clear();
            map.put("stringIndexed[1]", "New String 1");
            map.put("stringIndexed[3]", "New String 3");
            BeanUtils.populate((Object)this.bean, map);
            BeanUtilsTestCase.assertEquals((String)"stringIndexed[0] is \"String 0\"", (String)"String 0", (String)this.bean.getStringIndexed(0));
            BeanUtilsTestCase.assertEquals((String)"stringIndexed[1] is \"New String 1\"", (String)"New String 1", (String)this.bean.getStringIndexed(1));
            BeanUtilsTestCase.assertEquals((String)"stringIndexed[2] is \"String 2\"", (String)"String 2", (String)this.bean.getStringIndexed(2));
            BeanUtilsTestCase.assertEquals((String)"stringIndexed[3] is \"New String 3\"", (String)"New String 3", (String)this.bean.getStringIndexed(3));
            BeanUtilsTestCase.assertEquals((String)"stringIndexed[4] is \"String 4\"", (String)"String 4", (String)this.bean.getStringIndexed(4));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateArrayProperties() {
        try {
            HashMap<String, Object[]> map = new HashMap<String, Object[]>();
            int[] intArray = new int[]{123, 456, 789};
            map.put("intArray", intArray);
            String[] stringArray = new String[]{"New String 0", "New String 1"};
            map.put("stringArray", stringArray);
            BeanUtils.populate((Object)this.bean, map);
            intArray = this.bean.getIntArray();
            BeanUtilsTestCase.assertNotNull((String)"intArray is present", (Object)intArray);
            BeanUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
            BeanUtilsTestCase.assertEquals((String)"intArray[0]", (int)123, (int)intArray[0]);
            BeanUtilsTestCase.assertEquals((String)"intArray[1]", (int)456, (int)intArray[1]);
            BeanUtilsTestCase.assertEquals((String)"intArray[2]", (int)789, (int)intArray[2]);
            stringArray = this.bean.getStringArray();
            BeanUtilsTestCase.assertNotNull((String)"stringArray is present", (Object)stringArray);
            BeanUtilsTestCase.assertEquals((String)"stringArray length", (int)2, (int)stringArray.length);
            BeanUtilsTestCase.assertEquals((String)"stringArray[0]", (String)"New String 0", (String)stringArray[0]);
            BeanUtilsTestCase.assertEquals((String)"stringArray[1]", (String)"New String 1", (String)stringArray[1]);
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateMapped() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("mappedProperty(First Key)", "New First Value");
            map.put("mappedProperty(Third Key)", "New Third Value");
            BeanUtils.populate((Object)this.bean, map);
            BeanUtilsTestCase.assertEquals((String)"mappedProperty(First Key)", (String)"New First Value", (String)this.bean.getMappedProperty("First Key"));
            BeanUtilsTestCase.assertEquals((String)"mappedProperty(Second Key)", (String)"Second Value", (String)this.bean.getMappedProperty("Second Key"));
            BeanUtilsTestCase.assertEquals((String)"mappedProperty(Third Key)", (String)"New Third Value", (String)this.bean.getMappedProperty("Third Key"));
            BeanUtilsTestCase.assertNull((String)"mappedProperty(Fourth Key", (Object)this.bean.getMappedProperty("Fourth Key"));
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateNested() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nested.booleanProperty", "false");
            map.put("nested.doubleProperty", "432.0");
            map.put("nested.intProperty", "543");
            map.put("nested.shortProperty", "654");
            map.put("nested.writeOnlyProperty", "New writeOnlyProperty value");
            BeanUtils.populate((Object)this.bean, map);
            BeanUtilsTestCase.assertTrue((String)"booleanProperty is false", (!this.bean.getNested().getBooleanProperty() ? 1 : 0) != 0);
            BeanUtilsTestCase.assertTrue((String)"booleanSecond is true", (boolean)this.bean.getNested().isBooleanSecond());
            BeanUtilsTestCase.assertEquals((String)"doubleProperty is 432.0", (double)432.0, (double)this.bean.getNested().getDoubleProperty(), (double)0.005);
            BeanUtilsTestCase.assertEquals((String)"floatProperty is 123.0", (float)123.0f, (float)this.bean.getNested().getFloatProperty(), (float)0.005f);
            BeanUtilsTestCase.assertEquals((String)"intProperty is 543", (int)543, (int)this.bean.getNested().getIntProperty());
            BeanUtilsTestCase.assertEquals((String)"longProperty is 321", (long)321L, (long)this.bean.getNested().getLongProperty());
            BeanUtilsTestCase.assertEquals((String)"shortProperty is 654", (short)654, (short)this.bean.getNested().getShortProperty());
            BeanUtilsTestCase.assertEquals((String)"stringProperty is \"This is a string\"", (String)"This is a string", (String)this.bean.getNested().getStringProperty());
            BeanUtilsTestCase.assertEquals((String)"writeOnlyProperty is \"New writeOnlyProperty value\"", (String)"New writeOnlyProperty value", (String)this.bean.getNested().getWriteOnlyPropertyValue());
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testPopulateScalar() {
        try {
            this.bean.setNullProperty("Non-null value");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("booleanProperty", "false");
            map.put("byteProperty", "111");
            map.put("doubleProperty", "432.0");
            map.put("intProperty", "543");
            map.put("longProperty", "");
            map.put("nullProperty", null);
            map.put("shortProperty", "654");
            map.put("writeOnlyProperty", "New writeOnlyProperty value");
            map.put("readOnlyProperty", "New readOnlyProperty value");
            BeanUtils.populate((Object)this.bean, map);
            BeanUtilsTestCase.assertTrue((String)"booleanProperty is false", (!this.bean.getBooleanProperty() ? 1 : 0) != 0);
            BeanUtilsTestCase.assertTrue((String)"booleanSecond is true", (boolean)this.bean.isBooleanSecond());
            BeanUtilsTestCase.assertEquals((String)"byteProperty is 111", (byte)111, (byte)this.bean.getByteProperty());
            BeanUtilsTestCase.assertEquals((String)"doubleProperty is 432.0", (double)432.0, (double)this.bean.getDoubleProperty(), (double)0.005);
            BeanUtilsTestCase.assertEquals((String)"floatProperty is 123.0", (float)123.0f, (float)this.bean.getFloatProperty(), (float)0.005f);
            BeanUtilsTestCase.assertEquals((String)"intProperty is 543", (int)543, (int)this.bean.getIntProperty());
            BeanUtilsTestCase.assertEquals((String)"longProperty is 0", (long)0L, (long)this.bean.getLongProperty());
            BeanUtilsTestCase.assertNull((String)"nullProperty is null", (Object)this.bean.getNullProperty());
            BeanUtilsTestCase.assertEquals((String)"shortProperty is 654", (short)654, (short)this.bean.getShortProperty());
            BeanUtilsTestCase.assertEquals((String)"stringProperty is \"This is a string\"", (String)"This is a string", (String)this.bean.getStringProperty());
            BeanUtilsTestCase.assertEquals((String)"writeOnlyProperty is \"New writeOnlyProperty value\"", (String)"New writeOnlyProperty value", (String)this.bean.getWriteOnlyPropertyValue());
            BeanUtilsTestCase.assertEquals((String)"readOnlyProperty is \"Read Only String Property\"", (String)"Read Only String Property", (String)this.bean.getReadOnlyProperty());
        }
        catch (IllegalAccessException e) {
            BeanUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            BeanUtilsTestCase.fail((String)"InvocationTargetException");
        }
    }

    public void testSetPropertyNullValues() throws Exception {
        Object oldValue = null;
        Object newValue = null;
        oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)null);
        newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtilsTestCase.assertNotNull((String)"stringArray is not null", (Object)newValue);
        BeanUtilsTestCase.assertTrue((String)"stringArray of correct type", (boolean)(newValue instanceof String[]));
        BeanUtilsTestCase.assertEquals((String)"stringArray length", (int)1, (int)((String[])newValue).length);
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray[2]", (Object)null);
        newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtilsTestCase.assertNotNull((String)"stringArray is not null", (Object)newValue);
        BeanUtilsTestCase.assertTrue((String)"stringArray of correct type", (boolean)(newValue instanceof String[]));
        BeanUtilsTestCase.assertEquals((String)"stringArray length", (int)5, (int)((String[])newValue).length);
        BeanUtilsTestCase.assertTrue((String)"stringArray[2] is null", (((String[])newValue)[2] == null ? 1 : 0) != 0);
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", null);
        BeanUtilsTestCase.assertTrue((String)"stringProperty is now null", (BeanUtils.getProperty((Object)this.bean, (String)"stringProperty") == null ? 1 : 0) != 0);
    }

    public void testSetPropertyOnPrimitiveWrappers() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"intProperty", (Object)new Integer(1));
        BeanUtilsTestCase.assertEquals((int)1, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)new Integer(1));
        BeanUtilsTestCase.assertEquals((int)1, (int)Integer.parseInt(this.bean.getStringProperty()));
    }

    public void testSetPropertyByte() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
    }

    public void testSetPropertyConvert() {
        try {
            BeanUtils.setProperty((Object)this.bean, (String)"dateProperty", (Object)this.testCalendar);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"Calendar --> java.util.Date", (Object)this.testUtilDate, (Object)this.bean.getDateProperty());
    }

    public void testSetPropertyConvertFromString() {
        try {
            BeanUtils.setProperty((Object)this.bean, (String)"dateProperty", (Object)this.testStringDate);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"String --> java.util.Date", (Object)this.testUtilDate, (Object)this.bean.getDateProperty());
    }

    public void testSetPropertyConvertToString() {
        try {
            BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date --> String", (String)this.testUtilDate.toString(), (String)this.bean.getStringProperty());
    }

    public void testSetPropertyConvertToStringArray() {
        try {
            this.bean.setStringArray(null);
            BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)new Date[]{this.testUtilDate});
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)this.bean.getStringArray().length);
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testUtilDate.toString(), (String)this.bean.getStringArray()[0]);
    }

    public void testSetPropertyConvertToStringIndexed() {
        try {
            this.bean.setStringArray(new String[1]);
            BeanUtils.setProperty((Object)this.bean, (String)"stringArray[0]", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date --> String[]", (String)this.testUtilDate.toString(), (String)this.bean.getStringArray()[0]);
    }

    public void testSetPropertyDouble() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
    }

    public void testSetPropertyFloat() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
    }

    public void testSetPropertyInteger() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
    }

    public void testSetPropertyLong() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
    }

    public void testSetPropertyNull() throws Exception {
        this.bean.setNullProperty("non-null value");
        BeanUtils.setProperty((Object)this.bean, (String)"nullProperty", null);
        BeanUtilsTestCase.assertNull((String)"nullProperty is null", (Object)this.bean.getNullProperty());
    }

    public void testSetPropertyShort() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
    }

    public void testSetPropertyStringToArray() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)"ABC,DEF,GHI");
        String[] strArray = this.bean.getStringArray();
        BeanUtilsTestCase.assertEquals((String)"length", (int)3, (int)strArray.length);
        BeanUtilsTestCase.assertEquals((String)"value[0]", (String)"ABC", (String)strArray[0]);
        BeanUtilsTestCase.assertEquals((String)"value[1]", (String)"DEF", (String)strArray[1]);
        BeanUtilsTestCase.assertEquals((String)"value[2]", (String)"GHI", (String)strArray[2]);
        BeanUtils.setProperty((Object)this.bean, (String)"intArray", (Object)"0, 10, 20, 30, 40");
        int[] intArray = this.bean.getIntArray();
        BeanUtilsTestCase.assertEquals((String)"length", (int)5, (int)intArray.length);
        BeanUtilsTestCase.assertEquals((String)"value[0]", (int)0, (int)intArray[0]);
        BeanUtilsTestCase.assertEquals((String)"value[1]", (int)10, (int)intArray[1]);
        BeanUtilsTestCase.assertEquals((String)"value[2]", (int)20, (int)intArray[2]);
        BeanUtilsTestCase.assertEquals((String)"value[3]", (int)30, (int)intArray[3]);
        BeanUtilsTestCase.assertEquals((String)"value[4]", (int)40, (int)intArray[4]);
    }

    public void testCopyPropertyByte() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((byte)123, (byte)this.bean.getByteProperty());
    }

    public void testCopyPropertyConvert() {
        try {
            BeanUtils.copyProperty((Object)this.bean, (String)"dateProperty", (Object)this.testCalendar);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"Calendar --> java.util.Date", (Object)this.testUtilDate, (Object)this.bean.getDateProperty());
    }

    public void testCopyPropertyConvertFromString() {
        try {
            BeanUtils.copyProperty((Object)this.bean, (String)"dateProperty", (Object)this.testStringDate);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"String --> java.util.Date", (Object)this.testUtilDate, (Object)this.bean.getDateProperty());
    }

    public void testCopyPropertyConvertToString() {
        try {
            BeanUtils.copyProperty((Object)this.bean, (String)"stringProperty", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date --> String", (String)this.testUtilDate.toString(), (String)this.bean.getStringProperty());
    }

    public void testCopyPropertyConvertToStringArray() {
        try {
            this.bean.setStringArray(null);
            BeanUtils.copyProperty((Object)this.bean, (String)"stringArray", (Object)new Date[]{this.testUtilDate});
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)this.bean.getStringArray().length);
        BeanUtilsTestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testUtilDate.toString(), (String)this.bean.getStringArray()[0]);
    }

    public void testCopyPropertyConvertToStringIndexed() {
        try {
            this.bean.setStringArray(new String[1]);
            BeanUtils.copyProperty((Object)this.bean, (String)"stringArray[0]", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t));
        }
        BeanUtilsTestCase.assertEquals((String)"java.util.Date --> String[]", (String)this.testUtilDate.toString(), (String)this.bean.getStringArray()[0]);
    }

    public void testCopyPropertyDouble() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
    }

    public void testCopyPropertyFloat() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
    }

    public void testCopyPropertyInteger() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((int)123, (int)this.bean.getIntProperty());
    }

    public void testCopyPropertyLong() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((long)123L, (long)this.bean.getLongProperty());
    }

    public void testCopyPropertyShort() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)new Byte(123));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)new Double(123.0));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)new Float(123.0f));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)new Long(123L));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)new Short(123));
        BeanUtilsTestCase.assertEquals((short)123, (short)this.bean.getShortProperty());
    }

    public void testCopyPropertyNestedIndexedArray() throws Exception {
        int[] origArray = new int[]{0, 10, 20, 30, 40};
        int[] intArray = new int[]{0, 0, 0};
        this.bean.getNested().setIntArray(intArray);
        int[] intChanged = new int[]{0, 0, 0};
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)new Integer(1));
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 1;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)new Byte(2));
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 2;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)new Long(3L));
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 3;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)"4");
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 4;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
    }

    public void testCopyPropertyNestedMappedMap() throws Exception {
        HashMap<String, String> origMap = new HashMap<String, String>();
        origMap.put("First Key", "First Value");
        origMap.put("Second Key", "Second Value");
        HashMap<String, String> changedMap = new HashMap<String, String>();
        changedMap.put("First Key", "First Value");
        changedMap.put("Second Key", "Second Value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.mapProperty(Second Key)", (Object)"New Second Value");
        this.checkMap(this.bean.getMapProperty(), origMap);
        changedMap.put("Second Key", "New Second Value");
        this.checkMap(this.bean.getNested().getMapProperty(), changedMap);
    }

    public void testCopyPropertyNestedSimple() throws Exception {
        this.bean.setIntProperty(0);
        this.bean.getNested().setIntProperty(0);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)new Integer(1));
        BeanUtilsTestCase.assertNotNull((Object)this.bean.getNested());
        BeanUtilsTestCase.assertEquals((int)0, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((int)1, (int)this.bean.getNested().getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)new Byte(2));
        BeanUtilsTestCase.assertNotNull((Object)this.bean.getNested());
        BeanUtilsTestCase.assertEquals((int)0, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((int)2, (int)this.bean.getNested().getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)new Long(3L));
        BeanUtilsTestCase.assertNotNull((Object)this.bean.getNested());
        BeanUtilsTestCase.assertEquals((int)0, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((int)3, (int)this.bean.getNested().getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)"4");
        BeanUtilsTestCase.assertNotNull((Object)this.bean.getNested());
        BeanUtilsTestCase.assertEquals((int)0, (int)this.bean.getIntProperty());
        BeanUtilsTestCase.assertEquals((int)4, (int)this.bean.getNested().getIntProperty());
    }

    public void testCopyPropertyNull() throws Exception {
        this.bean.setNullProperty("non-null value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nullProperty", null);
        BeanUtilsTestCase.assertNull((String)"nullProperty is null", (Object)this.bean.getNullProperty());
    }

    public void testCopyPropertyWriteOnly() throws Exception {
        this.bean.setWriteOnlyProperty("Original value");
        BeanUtils.copyProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)"New value");
        BeanUtilsTestCase.assertEquals((String)"New value", (String)this.bean.getWriteOnlyPropertyValue());
        BeanUtils.copyProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((String)"123", (String)this.bean.getWriteOnlyPropertyValue());
    }

    public void testSetPropertyWriteOnly() throws Exception {
        this.bean.setWriteOnlyProperty("Original value");
        BeanUtils.setProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)"New value");
        BeanUtilsTestCase.assertEquals((String)"New value", (String)this.bean.getWriteOnlyPropertyValue());
        BeanUtils.setProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)new Integer(123));
        BeanUtilsTestCase.assertEquals((String)"123", (String)this.bean.getWriteOnlyPropertyValue());
    }

    public void testSetMappedMap() {
        TestBean bean = new TestBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sub-key-1", "sub-value-1");
        map.put("sub-key-2", "sub-value-2");
        map.put("sub-key-3", "sub-value-3");
        bean.getMapProperty().put("mappedMap", map);
        BeanUtilsTestCase.assertEquals((String)"BEFORE", (Object)"sub-value-3", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"));
        try {
            BeanUtils.setProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-3)", (Object)"SUB-KEY-3-UPDATED");
        }
        catch (Throwable t) {
            BeanUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        BeanUtilsTestCase.assertEquals((String)"AFTER", (Object)"SUB-KEY-3-UPDATED", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"));
    }

    public void testSeparateInstances() throws Exception {
        BeanUtilsBean utilsOne = new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean());
        BeanUtilsBean utilsTwo = new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean());
        TestBean bean = new TestBean();
        bean.setBooleanProperty(false);
        utilsOne.setProperty((Object)bean, "booleanProperty", (Object)"true");
        BeanUtilsTestCase.assertEquals((String)"Set property failed (1)", (boolean)bean.getBooleanProperty(), (boolean)true);
        bean.setBooleanProperty(false);
        utilsTwo.setProperty((Object)bean, "booleanProperty", (Object)"true");
        BeanUtilsTestCase.assertEquals((String)"Set property failed (2)", (boolean)bean.getBooleanProperty(), (boolean)true);
        utilsOne.getConvertUtils().register((Converter)new ThrowExceptionConverter(), Boolean.TYPE);
        try {
            bean.setBooleanProperty(false);
            utilsOne.setProperty((Object)bean, "booleanProperty", (Object)"true");
            BeanUtilsTestCase.fail((String)"Registered conversion not used.");
        }
        catch (PassTestException e) {
            // empty catch block
        }
        try {
            bean.setBooleanProperty(false);
            utilsTwo.setProperty((Object)bean, "booleanProperty", (Object)"true");
            BeanUtilsTestCase.assertEquals((String)"Set property failed (3)", (boolean)bean.getBooleanProperty(), (boolean)true);
        }
        catch (PassTestException e) {
            BeanUtilsTestCase.fail((String)"Registed converter is used by other instances");
        }
    }

    public void testArrayPropertyConversion() throws Exception {
        BeanUtilsBean beanUtils = new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean());
        TestBean bean = new TestBean();
        String[] results = beanUtils.getArrayProperty((Object)bean, "intArray");
        int[] values = bean.getIntArray();
        BeanUtilsTestCase.assertEquals((String)"Converted array size not equal to property array size.", (int)results.length, (int)values.length);
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            BeanUtilsTestCase.assertEquals((String)("Value " + i + " incorrectly converted "), (String)(values[i] + ""), (String)results[i]);
        }
    }

    protected void checkIntArray(int[] actual, int[] expected) {
        BeanUtilsTestCase.assertNotNull((String)"actual array not null", (Object)actual);
        BeanUtilsTestCase.assertEquals((String)"actual array length", (int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            BeanUtilsTestCase.assertEquals((String)("actual array value[" + i + "]"), (int)expected[i], (int)actual[i]);
        }
    }

    protected void checkMap(Map<?, ?> actual, Map<?, ?> expected) {
        BeanUtilsTestCase.assertNotNull((String)"actual map not null", actual);
        BeanUtilsTestCase.assertEquals((String)"actual map size", (int)expected.size(), (int)actual.size());
        for (Object key : expected.keySet()) {
            BeanUtilsTestCase.assertEquals((String)("actual map value(" + key + ")"), expected.get(key), actual.get(key));
        }
    }

    public void testMappedProperty() throws Exception {
        MappedPropertyTestBean bean = new MappedPropertyTestBean();
        BeanUtils.setProperty((Object)bean, (String)"mapproperty(this.that.the-other)", (Object)"some.dotty.value");
        BeanUtilsTestCase.assertEquals((String)"Mapped property set correctly", (String)"some.dotty.value", (String)bean.getMapproperty("this.that.the-other"));
    }

    public void testInitCause() {
        if (BeanUtilsTestCase.isPre14JVM()) {
            return;
        }
        String parentMsg = "PARENT-THROWABLE";
        String causeMsg = "THROWABLE-CAUSE";
        try {
            this.initCauseAndThrowException(parentMsg, causeMsg);
        }
        catch (Throwable thrownParent) {
            BeanUtilsTestCase.assertEquals((String)"Parent", (String)parentMsg, (String)thrownParent.getMessage());
            try {
                BeanUtilsTestCase.assertEquals((String)"Parent", (String)parentMsg, (String)thrownParent.getMessage());
                Throwable thrownCause = this.getCause(thrownParent);
                BeanUtilsTestCase.assertNotNull((String)"Cause Null", (Object)thrownCause);
                BeanUtilsTestCase.assertEquals((String)"Cause", (String)causeMsg, (String)thrownCause.getMessage());
            }
            catch (Throwable testError) {
                BeanUtilsTestCase.fail((String)("If you're running JDK 1.3 then don't worry this should fail, if not then needs checking out: " + testError));
            }
        }
    }

    private Throwable getCause(Throwable t) throws Throwable {
        return (Throwable)PropertyUtils.getProperty((Object)t, (String)"cause");
    }

    private void initCauseAndThrowException(String parent, String cause) throws Throwable {
        try {
            this.throwException(cause);
        }
        catch (Throwable e) {
            Exception t = new Exception(parent);
            BeanUtils.initCause((Throwable)t, (Throwable)e);
            throw t;
        }
    }

    private void throwException(String msg) throws Throwable {
        throw new Exception(msg);
    }

    public static boolean isPre14JVM() {
        String version = System.getProperty("java.specification.version");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        if (tokenizer.nextToken().equals("1")) {
            String minorVersion = tokenizer.nextToken();
            if (minorVersion.equals("0")) {
                return true;
            }
            if (minorVersion.equals("1")) {
                return true;
            }
            if (minorVersion.equals("2")) {
                return true;
            }
            if (minorVersion.equals("3")) {
                return true;
            }
        }
        return false;
    }
}

