/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.IndexedTestBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexedPropertyTestCase
extends TestCase {
    private static final Log log = LogFactory.getLog(IndexedPropertyTestCase.class);
    private IndexedTestBean bean = null;
    private BeanUtilsBean beanUtilsBean;
    private PropertyUtilsBean propertyUtilsBean;
    private String[] testArray;
    private String[] newArray;
    private List<String> testList;
    private List<Object> newList;
    private ArrayList<Object> arrayList;

    public IndexedPropertyTestCase(String name) {
        super(name);
    }

    public void setUp() {
        this.beanUtilsBean = new BeanUtilsBean();
        this.propertyUtilsBean = this.beanUtilsBean.getPropertyUtils();
        this.testArray = new String[]{"array-0", "array-1", "array-2"};
        this.newArray = new String[]{"newArray-0", "newArray-1", "newArray-2"};
        this.testList = new ArrayList<String>();
        this.testList.add("list-0");
        this.testList.add("list-1");
        this.testList.add("list-2");
        this.newList = new ArrayList<Object>();
        this.newList.add("newList-0");
        this.newList.add("newList-1");
        this.newList.add("newList-2");
        this.arrayList = new ArrayList();
        this.arrayList.add("arrayList-0");
        this.arrayList.add("arrayList-1");
        this.arrayList.add("arrayList-2");
        this.bean = new IndexedTestBean();
        this.bean.setStringArray(this.testArray);
        this.bean.setStringList(this.testList);
        this.bean.setArrayList(this.arrayList);
    }

    public static Test suite() {
        return new TestSuite(IndexedPropertyTestCase.class);
    }

    public void tearDown() {
        this.bean = null;
    }

    public void testArrayIndexedPropertyDescriptor() {
        try {
            PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
            IndexedPropertyTestCase.assertNotNull((String)"No Array Descriptor", (Object)descriptor);
            IndexedPropertyTestCase.assertEquals((String)"Not IndexedPropertyDescriptor", IndexedPropertyDescriptor.class, descriptor.getClass());
            IndexedPropertyTestCase.assertEquals((String)"PropertDescriptor Type invalid", this.testArray.getClass(), descriptor.getPropertyType());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testListIndexedPropertyDescriptor() {
        try {
            PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
            IndexedPropertyTestCase.assertNotNull((String)"No List Descriptor", (Object)descriptor);
            IndexedPropertyTestCase.assertEquals((String)"Not IndexedPropertyDescriptor", IndexedPropertyDescriptor.class, descriptor.getClass());
            IndexedPropertyTestCase.assertEquals((String)"PropertDescriptor Type invalid", List.class, descriptor.getPropertyType());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayListIndexedPropertyDescriptor() {
        try {
            PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
            IndexedPropertyTestCase.assertNotNull((String)"No ArrayList Descriptor", (Object)descriptor);
            IndexedPropertyTestCase.assertEquals((String)"Not IndexedPropertyDescriptor", IndexedPropertyDescriptor.class, descriptor.getClass());
            IndexedPropertyTestCase.assertEquals((String)"PropertDescriptor Type invalid", ArrayList.class, descriptor.getPropertyType());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayReadMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
            IndexedPropertyTestCase.assertNotNull((String)"No Array Read Method", (Object)descriptor.getReadMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayWriteMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
            IndexedPropertyTestCase.assertNotNull((String)"No Array Write Method", (Object)descriptor.getWriteMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayIndexedReadMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
            IndexedPropertyTestCase.assertNotNull((String)"No Array Indexed Read Method", (Object)descriptor.getIndexedReadMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayIndexedWriteMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
            IndexedPropertyTestCase.assertNotNull((String)"No Array Indexed Write Method", (Object)descriptor.getIndexedWriteMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testListReadMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
            IndexedPropertyTestCase.assertNotNull((String)"No List Read Method", (Object)descriptor.getReadMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testListWriteMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
            IndexedPropertyTestCase.assertNotNull((String)"No List Write Method", (Object)descriptor.getWriteMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testListIndexedReadMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
            IndexedPropertyTestCase.assertNotNull((String)"No List Indexed Read Method", (Object)descriptor.getIndexedReadMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testListIndexedWriteMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
            IndexedPropertyTestCase.assertNotNull((String)"No List Indexed Write Method", (Object)descriptor.getIndexedWriteMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayListReadMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
            IndexedPropertyTestCase.assertNotNull((String)"No ArrayList Read Method", (Object)descriptor.getReadMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testArrayListWriteMethod() {
        try {
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
            IndexedPropertyTestCase.assertNotNull((String)"No ArrayList Write Method", (Object)descriptor.getWriteMethod());
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetArray() {
        try {
            IndexedPropertyTestCase.assertEquals((Object)this.testArray, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "stringArray"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetArrayAsString() {
        try {
            IndexedPropertyTestCase.assertEquals((String)"array-0", (String)this.beanUtilsBean.getProperty((Object)this.bean, "stringArray"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetArrayItemA() {
        try {
            IndexedPropertyTestCase.assertEquals((String)"array-1", (String)this.beanUtilsBean.getProperty((Object)this.bean, "stringArray[1]"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetArrayItemB() {
        try {
            IndexedPropertyTestCase.assertEquals((String)"array-1", (String)this.beanUtilsBean.getIndexedProperty((Object)this.bean, "stringArray", 1));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetList() {
        try {
            IndexedPropertyTestCase.assertEquals(this.testList, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "stringList"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetListAsString() {
        try {
            IndexedPropertyTestCase.assertEquals((String)"list-0", (String)this.beanUtilsBean.getProperty((Object)this.bean, "stringList"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetListItemA() {
        try {
            IndexedPropertyTestCase.assertEquals((String)"list-1", (String)this.beanUtilsBean.getProperty((Object)this.bean, "stringList[1]"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetListItemB() {
        try {
            IndexedPropertyTestCase.assertEquals((String)"list-1", (String)this.beanUtilsBean.getIndexedProperty((Object)this.bean, "stringList", 1));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetArray() {
        try {
            this.beanUtilsBean.setProperty((Object)this.bean, "stringArray", (Object)this.newArray);
            String[] value = this.bean.getStringArray();
            IndexedPropertyTestCase.assertEquals((String)"Type is different", this.newArray.getClass(), value.getClass());
            String[] array = value;
            IndexedPropertyTestCase.assertEquals((String)"Array Length is different", (int)this.newArray.length, (int)array.length);
            for (int i = 0; i < array.length; ++i) {
                IndexedPropertyTestCase.assertEquals((String)("Element " + i + " is different"), (String)this.newArray[i], (String)array[i]);
            }
        }
        catch (Exception e) {
            log.error((Object)"testSetArray()", (Throwable)e);
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetArrayItemA() {
        try {
            this.beanUtilsBean.setProperty((Object)this.bean, "stringArray[1]", (Object)"modified-1");
            IndexedPropertyTestCase.assertEquals((String)"modified-1", (String)this.bean.getStringArray(1));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetArrayItemB() {
        try {
            this.propertyUtilsBean.setIndexedProperty((Object)this.bean, "stringArray", 1, (Object)"modified-1");
            IndexedPropertyTestCase.assertEquals((String)"modified-1", (String)this.bean.getStringArray(1));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetList() {
        try {
            this.beanUtilsBean.setProperty((Object)this.bean, "stringList", this.newList);
            List<String> value = this.bean.getStringList();
            IndexedPropertyTestCase.assertEquals((String)"Type is different", this.newList.getClass(), value.getClass());
            List<String> list = value;
            IndexedPropertyTestCase.assertEquals((String)"List size is different", (int)this.newList.size(), (int)list.size());
            for (int i = 0; i < list.size(); ++i) {
                IndexedPropertyTestCase.assertEquals((String)("Element " + i + " is different"), (Object)this.newList.get(i), (Object)list.get(i));
            }
        }
        catch (Exception e) {
            log.error((Object)"testSetList()", (Throwable)e);
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetListItemA() {
        try {
            this.beanUtilsBean.setProperty((Object)this.bean, "stringList[1]", (Object)"modified-1");
            IndexedPropertyTestCase.assertEquals((String)"modified-1", (String)this.bean.getStringList(1));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetListItemB() {
        try {
            this.propertyUtilsBean.setIndexedProperty((Object)this.bean, "stringList", 1, (Object)"modified-1");
            IndexedPropertyTestCase.assertEquals((String)"modified-1", (String)this.bean.getStringList(1));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testGetArrayList() {
        try {
            IndexedPropertyTestCase.assertEquals(this.arrayList, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "arrayList"));
        }
        catch (Exception e) {
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }

    public void testSetArrayList() {
        try {
            this.beanUtilsBean.setProperty((Object)this.bean, "arrayList", this.newList);
            ArrayList<Object> value = this.bean.getArrayList();
            IndexedPropertyTestCase.assertEquals((String)"Type is different", this.newList.getClass(), value.getClass());
            List list = value;
            IndexedPropertyTestCase.assertEquals((String)"List size is different", (int)this.newList.size(), (int)list.size());
            for (int i = 0; i < list.size(); ++i) {
                IndexedPropertyTestCase.assertEquals((String)("Element " + i + " is different"), (Object)this.newList.get(i), list.get(i));
            }
        }
        catch (Exception e) {
            log.error((Object)"testSetList()", (Throwable)e);
            IndexedPropertyTestCase.fail((String)("Threw exception " + e));
        }
    }
}

