/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TestResultSetMetaData
implements InvocationHandler {
    protected String[][] metadata = new String[][]{{"bigDecimalProperty", BigDecimal.class.getName()}, {"booleanProperty", Boolean.class.getName()}, {"byteProperty", Byte.class.getName()}, {"dateProperty", Date.class.getName()}, {"doubleProperty", Double.class.getName()}, {"floatProperty", Float.class.getName()}, {"intProperty", Integer.class.getName()}, {"longProperty", Long.class.getName()}, {"nullProperty", String.class.getName()}, {"shortProperty", Short.class.getName()}, {"stringProperty", String.class.getName()}, {"timeProperty", Time.class.getName()}, {"timestampProperty", Timestamp.class.getName()}};

    public static ResultSetMetaData createProxy() {
        return TestResultSetMetaData.createProxy(new TestResultSetMetaData());
    }

    public static ResultSetMetaData createProxy(InvocationHandler invocationHandler) {
        ClassLoader classLoader = ResultSetMetaData.class.getClassLoader();
        Class[] interfaces = new Class[]{ResultSetMetaData.class};
        return (ResultSetMetaData)Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getColumnClassName".equals(methodName)) {
            return this.getColumnClassName((Integer)args[0]);
        }
        if ("getColumnCount".equals(methodName)) {
            return new Integer(this.getColumnCount());
        }
        if ("getColumnName".equals(methodName)) {
            return this.getColumnName((Integer)args[0]);
        }
        if ("getColumnType".equals(methodName)) {
            return this.getColumnType((Integer)args[0]);
        }
        throw new UnsupportedOperationException(methodName + " not implemented");
    }

    public String getColumnClassName(int columnIndex) throws SQLException {
        return this.metadata[columnIndex - 1][1];
    }

    public int getColumnCount() throws SQLException {
        return this.metadata.length;
    }

    public String getColumnName(int columnIndex) throws SQLException {
        return this.metadata[columnIndex - 1][0];
    }

    public Integer getColumnType(int columnIndex) throws SQLException {
        String columnName = this.getColumnName(columnIndex);
        int sqlType = 1111;
        sqlType = columnName.equals("bigDecimalProperty") ? 3 : (columnName.equals("byteProperty") ? -6 : (columnName.equals("dateProperty") ? 91 : (columnName.equals("doubleProperty") ? 8 : (columnName.equals("floatProperty") ? 6 : (columnName.equals("intProperty") ? 4 : (columnName.equals("longProperty") ? -5 : (columnName.equals("nullProperty") ? 12 : (columnName.equals("shortProperty") ? 5 : (columnName.equals("stringProperty") ? 12 : (columnName.equals("timeProperty") ? 92 : (columnName.equals("timestampProperty") ? 93 : 1111)))))))))));
        return new Integer(sqlType);
    }

    public String getCatalogName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getPrecision(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getScale(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSchemaName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getTableName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrency(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int isNullable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isSearchable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isSigned(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

