/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.beans.PropertyDescriptor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jira357TestCase
extends TestCase {
    public Jira357TestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Jira357TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira357TestCase.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPropertyUtils_getPropertyDescriptors_Foo() throws Exception {
        this.checkReadMethod("foo", ConcreteTestBean.class);
    }

    public void testPropertyUtils_getPropertyDescriptors_Bar() throws Exception {
    }

    public void testPropertyUtils_getPropertyDescriptors_InnerClassProperty() throws Exception {
        this.checkReadMethod("innerClassProperty", ConcreteTestBean.class);
    }

    private void checkReadMethod(String propertyName, Class<?> expectedDeclaringClass) throws Exception {
        PropertyDescriptor[] descriptors = null;
        try {
            descriptors = PropertyUtils.getPropertyDescriptors(ConcreteTestBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            Jira357TestCase.fail((String)("Threw: " + e));
        }
        PropertyDescriptor descriptor = this.findDescriptor(propertyName, descriptors);
        Jira357TestCase.assertNotNull((String)(propertyName + "descriptor"), (Object)descriptor);
        Jira357TestCase.assertEquals((String)(propertyName + " read method declaring class"), expectedDeclaringClass, descriptor.getReadMethod().getDeclaringClass());
    }

    private PropertyDescriptor findDescriptor(String propertyName, PropertyDescriptor[] descriptors) {
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!propertyName.equals(descriptors[i].getName())) continue;
                return descriptors[i];
            }
        }
        return null;
    }

    public static class ConcreteTestBean
    extends AbstractTestBean {
        private String foo;
        private boolean bar;
        private AbstractTestBean.InnerClass innerClassProperty;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public boolean isBar() {
            return this.bar;
        }

        public void setBar(boolean bar) {
            this.bar = bar;
        }

        public AbstractTestBean.InnerClass getInnerClassProperty() {
            return this.innerClassProperty;
        }

        public void setInnerClassProperty(AbstractTestBean.InnerClass innerClassProperty) {
            this.innerClassProperty = innerClassProperty;
        }
    }

    public static abstract class AbstractTestBean {
        public abstract String getFoo();

        public abstract void setFoo(String var1);

        public abstract boolean isBar();

        public abstract void setBar(boolean var1);

        public abstract InnerClass getInnerClassProperty();

        public static abstract class InnerClass {
            private String firstName;

            public String getInnerName() {
                return this.firstName;
            }

            public void setInnerName(String firstName) {
                this.firstName = firstName;
            }
        }
    }
}

