/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReloader
extends ClassLoader {
    public ClassReloader(ClassLoader parent) {
        super(parent);
    }

    public Class<?> reload(Class<?> clazz) throws FileNotFoundException, IOException {
        int bytesRead;
        String className = clazz.getName();
        String classFile = className.replace('.', '/') + ".class";
        InputStream classStream = this.getParent().getResourceAsStream(classFile);
        if (classStream == null) {
            throw new FileNotFoundException(classFile);
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((bytesRead = classStream.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
        }
        classStream.close();
        byte[] classData = baos.toByteArray();
        Class<?> newClass = this.defineClass(className, classData, 0, classData.length);
        this.resolveClass(newClass);
        return newClass;
    }
}

