/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public DoubleConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new Double("-12");
        this.numbers[1] = new Double("13");
        this.numbers[2] = new Double("-22");
        this.numbers[3] = new Double("23");
    }

    public static TestSuite suite() {
        return new TestSuite(DoubleConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new DoubleConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new DoubleConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Double.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Double.MIN_VALUE), "-17.2", "-1.1", "0.0", "1.1", "17.2", String.valueOf(Double.MAX_VALUE), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        Double[] expected = new Double[]{new Double(Double.MIN_VALUE), new Double(-17.2), new Double(-1.1), new Double(0.0), new Double(1.1), new Double(17.2), new Double(Double.MAX_VALUE), new Double(7.0), new Double(8.0), new Double(9.0), new Double(10.0), new Double(11.1), new Double(12.2)};
        for (int i = 0; i < expected.length; ++i) {
            DoubleConverterTestCase.assertEquals((String)(message[i] + " to Double"), (double)expected[i], (double)((Double)this.converter.convert(Double.class, input[i])), (double)1.0E-5);
            DoubleConverterTestCase.assertEquals((String)(message[i] + " to double"), (double)expected[i], (double)((Double)this.converter.convert(Double.TYPE, input[i])), (double)1.0E-5);
            DoubleConverterTestCase.assertEquals((String)(message[i] + " to null type"), (double)expected[i], (double)((Double)this.converter.convert(null, input[i])), (double)1.0E-5);
        }
    }
}

