/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public LongConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new Long("-12");
        this.numbers[1] = new Long("13");
        this.numbers[2] = new Long("-22");
        this.numbers[3] = new Long("23");
    }

    public static TestSuite suite() {
        return new TestSuite(LongConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new LongConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new LongConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Long.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Long.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Long.MAX_VALUE), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        Long[] expected = new Long[]{new Long(Long.MIN_VALUE), new Long(-17L), new Long(-1L), new Long(0L), new Long(1L), new Long(17L), new Long(Long.MAX_VALUE), new Long(7L), new Long(8L), new Long(9L), new Long(10L), new Long(11L), new Long(12L)};
        for (int i = 0; i < expected.length; ++i) {
            LongConverterTestCase.assertEquals((String)(message[i] + " to Long"), (Object)expected[i], (Object)this.converter.convert(Long.class, input[i]));
            LongConverterTestCase.assertEquals((String)(message[i] + " to long"), (Object)expected[i], (Object)this.converter.convert(Long.TYPE, input[i]));
            LongConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

