/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.lang.ref.WeakReference;
import junit.framework.TestCase;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ClassReloader;
import org.apache.commons.beanutils.converters.FloatConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTestCase
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWeakReference() throws Exception {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassReloader componentLoader = new ClassReloader(origContextClassLoader);
            Thread.currentThread().setContextClassLoader(componentLoader);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            WeakReference<ClassReloader> ref = new WeakReference<ClassReloader>(componentLoader);
            componentLoader = null;
            this.forceGarbageCollection(ref);
            MemoryTestCase.assertNull(ref.get());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            ConvertUtils.deregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComponentRegistersStandardConverter() throws Exception {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            MemoryTestCase.assertEquals((Object)origContextClassLoader, (Object)ConvertUtils.class.getClassLoader());
            ClassLoader componentLoader1 = new ClassLoader(){};
            ClassLoader componentLoader2 = new ClassLoader(){};
            Converter origFloatConverter = ConvertUtils.lookup(Float.TYPE);
            FloatConverter floatConverter1 = new FloatConverter();
            Thread.currentThread().setContextClassLoader(componentLoader1);
            MemoryTestCase.assertFalse((ConvertUtils.lookup(Float.TYPE) == origFloatConverter ? 1 : 0) != 0);
            ConvertUtils.register((Converter)floatConverter1, Float.TYPE);
            MemoryTestCase.assertTrue((ConvertUtils.lookup(Float.TYPE) == floatConverter1 ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            MemoryTestCase.assertTrue((ConvertUtils.lookup(Float.TYPE) == origFloatConverter ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(componentLoader2);
            MemoryTestCase.assertFalse((ConvertUtils.lookup(Float.TYPE) == origFloatConverter ? 1 : 0) != 0);
            MemoryTestCase.assertFalse((ConvertUtils.lookup(Float.TYPE) == floatConverter1 ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            WeakReference<1> weakRefToComponent1 = new WeakReference<1>(componentLoader1);
            componentLoader1 = null;
            this.forceGarbageCollection(weakRefToComponent1);
            MemoryTestCase.assertNull((String)"Component classloader did not release properly; memory leak present", weakRefToComponent1.get());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            ConvertUtils.deregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComponentRegistersCustomConverter() throws Exception {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            MemoryTestCase.assertEquals((Object)origContextClassLoader, (Object)ConvertUtils.class.getClassLoader());
            ClassReloader componentLoader = new ClassReloader(origContextClassLoader);
            Thread.currentThread().setContextClassLoader(componentLoader);
            Class<?> newFloatConverterClass = componentLoader.reload(FloatConverter.class);
            Object newFloatConverter = newFloatConverterClass.newInstance();
            MemoryTestCase.assertTrue((newFloatConverter.getClass().getClassLoader() == componentLoader ? 1 : 0) != 0);
            MemoryTestCase.assertTrue((String)"Converter loader via child does not implement parent type", (boolean)Converter.class.isInstance(newFloatConverter));
            ConvertUtils.register((Converter)((Converter)newFloatConverter), Float.TYPE);
            Converter componentConverter = ConvertUtils.lookup(Float.TYPE);
            MemoryTestCase.assertTrue((componentConverter.getClass().getClassLoader() == componentLoader ? 1 : 0) != 0);
            newFloatConverter = null;
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            Converter sharedConverter = ConvertUtils.lookup(Float.TYPE);
            MemoryTestCase.assertFalse((sharedConverter.getClass().getClassLoader() == componentLoader ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(componentLoader);
            Converter componentConverter2 = ConvertUtils.lookup(Float.TYPE);
            MemoryTestCase.assertTrue((componentConverter2.getClass().getClassLoader() == componentLoader ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            WeakReference<ClassReloader> weakRefToComponent = new WeakReference<ClassReloader>(componentLoader);
            componentLoader = null;
            this.forceGarbageCollection(weakRefToComponent);
            MemoryTestCase.assertNull((String)"Component classloader did not release properly; memory leak present", weakRefToComponent.get());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            ConvertUtils.deregister();
        }
    }

    private void forceGarbageCollection(WeakReference<?> target) {
        int bytes = 2;
        while (target.get() != null) {
            System.gc();
            try {
                byte[] b = new byte[bytes];
                bytes *= 2;
            }
            catch (OutOfMemoryError e) {
                // empty catch block
                break;
            }
        }
        System.gc();
    }
}

