/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.net.URL;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.URLConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLConverterTestCase
extends TestCase {
    private Converter converter = null;

    public URLConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    public static TestSuite suite() {
        return new TestSuite(URLConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    protected Converter makeConverter() {
        return new URLConverter();
    }

    protected Class<?> getExpectedType() {
        return URL.class;
    }

    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        Object[] input = new Object[]{"http://www.apache.org", "http://www.apache.org/", "ftp://cvs.apache.org", "file://project.xml", "http://208.185.179.12", "http://www.apache.org:9999/test/thing", "http://user:admin@www.apache.org:50/one/two.three", "http://notreal.apache.org"};
        URL[] expected = new URL[]{new URL("http://www.apache.org"), new URL("http://www.apache.org/"), new URL("ftp://cvs.apache.org"), new URL("file://project.xml"), new URL("http://208.185.179.12"), new URL("http://www.apache.org:9999/test/thing"), new URL("http://user:admin@www.apache.org:50/one/two.three"), new URL("http://notreal.apache.org")};
        for (i = 0; i < expected.length; ++i) {
            URLConverterTestCase.assertEquals((String)(message[i] + " to URL"), (Object)expected[i], (Object)this.converter.convert(URL.class, input[i]));
            URLConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
        for (i = 0; i < expected.length; ++i) {
            URLConverterTestCase.assertEquals((String)(input[i] + " to String"), (Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]));
        }
    }

    public void testUnsupportedType() {
        try {
            this.converter.convert(Integer.class, (Object)"http://www.apache.org");
            URLConverterTestCase.fail((String)"Unsupported type could be converted!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

