/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.LocaleConvertUtils;

public class LocaleConvertUtilsTestCase
extends TestCase {
    private char m_decimalSeparator;

    public LocaleConvertUtilsTestCase(String name) {
        super(name);
    }

    public void setUp() {
        LocaleConvertUtils.deregister();
        NumberFormat nf = DecimalFormat.getNumberInstance();
        String result = nf.format(1.1);
        this.m_decimalSeparator = result.charAt(1);
    }

    public static Test suite() {
        return new TestSuite(LocaleConvertUtilsTestCase.class);
    }

    public void tearDown() {
    }

    public void fixmetestNegativeIntegerArray() {
        LocaleConvertUtilsTestCase.fail((String)"Array conversions not implemented yet.");
        Object value = null;
        int[] intArray = new int[]{};
        value = LocaleConvertUtils.convert((String)null, intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"a", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"{ a }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"{ 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"0,1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"{ 0, 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
    }

    public void testNegativeScalar() {
        try {
            LocaleConvertUtils.convert((String)"foo", Byte.TYPE);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (1)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Byte.class);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (2)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Double.TYPE);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (3)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Double.class);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (4)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Float.TYPE);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (5)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Float.class);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (6)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Integer.TYPE);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (7)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Integer.class);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (8)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Byte.TYPE);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (9)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Long.class);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (10)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Short.TYPE);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (11)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            LocaleConvertUtils.convert((String)"foo", Short.class);
            LocaleConvertUtilsTestCase.fail((String)"Should have thrown conversion exception (12)");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void fixmetestNegativeStringArray() {
        LocaleConvertUtilsTestCase.fail((String)"Array conversions not implemented yet.");
        Object value = null;
        String[] stringArray = new String[]{};
        value = LocaleConvertUtils.convert((String)null, stringArray.getClass());
        this.checkStringArray(value, stringArray);
    }

    public void fixmetestObjectToStringArray() {
        LocaleConvertUtilsTestCase.fail((String)"Array conversions not implemented yet.");
        int[] intArray0 = new int[]{};
        int[] intArray1 = new int[]{123};
        int[] intArray2 = new int[]{123, 456};
        String[] stringArray0 = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "def"};
        LocaleConvertUtilsTestCase.assertEquals((String)"intArray0", null, (String)LocaleConvertUtils.convert((Object)intArray0));
        LocaleConvertUtilsTestCase.assertEquals((String)"intArray1", (String)"123", (String)LocaleConvertUtils.convert((Object)intArray1));
        LocaleConvertUtilsTestCase.assertEquals((String)"intArray2", (String)"123", (String)LocaleConvertUtils.convert((Object)intArray2));
        LocaleConvertUtilsTestCase.assertEquals((String)"stringArray0", null, (String)LocaleConvertUtils.convert((Object)stringArray0));
        LocaleConvertUtilsTestCase.assertEquals((String)"stringArray1", (String)"abc", (String)LocaleConvertUtils.convert((Object)stringArray1));
        LocaleConvertUtilsTestCase.assertEquals((String)"stringArray2", (String)"abc", (String)LocaleConvertUtils.convert((Object)stringArray2));
    }

    public void testObjectToStringScalar() {
        LocaleConvertUtilsTestCase.assertEquals((String)"Boolean->String", (String)"false", (String)LocaleConvertUtils.convert((Object)Boolean.FALSE));
        LocaleConvertUtilsTestCase.assertEquals((String)"Boolean->String", (String)"true", (String)LocaleConvertUtils.convert((Object)Boolean.TRUE));
        LocaleConvertUtilsTestCase.assertEquals((String)"Byte->String", (String)"123", (String)LocaleConvertUtils.convert((Object)new Byte(123)));
        LocaleConvertUtilsTestCase.assertEquals((String)"Character->String", (String)"a", (String)LocaleConvertUtils.convert((Object)new Character('a')));
        LocaleConvertUtilsTestCase.assertEquals((String)"Double->String", (String)("123" + this.m_decimalSeparator + "4"), (String)LocaleConvertUtils.convert((Object)new Double(123.4)));
        LocaleConvertUtilsTestCase.assertEquals((String)"Float->String", (String)("123" + this.m_decimalSeparator + "4"), (String)LocaleConvertUtils.convert((Object)new Float(123.4f)));
        LocaleConvertUtilsTestCase.assertEquals((String)"Integer->String", (String)"123", (String)LocaleConvertUtils.convert((Object)new Integer(123)));
        LocaleConvertUtilsTestCase.assertEquals((String)"Long->String", (String)"123", (String)LocaleConvertUtils.convert((Object)new Long(123L)));
        LocaleConvertUtilsTestCase.assertEquals((String)"Short->String", (String)"123", (String)LocaleConvertUtils.convert((Object)new Short(123)));
        LocaleConvertUtilsTestCase.assertEquals((String)"String->String", (String)"abc", (String)LocaleConvertUtils.convert((Object)"abc"));
        LocaleConvertUtilsTestCase.assertEquals((String)"String->String null", null, (String)LocaleConvertUtils.convert(null));
    }

    public void fixmetestPositiveArray() {
        LocaleConvertUtilsTestCase.fail((String)"Array conversions not implemented yet.");
        String[] values1 = new String[]{"10", "20", "30"};
        Object value = LocaleConvertUtils.convert((String[])values1, Integer.TYPE);
        int[] shape = new int[]{};
        LocaleConvertUtilsTestCase.assertEquals(shape.getClass(), value.getClass());
        int[] results1 = (int[])value;
        LocaleConvertUtilsTestCase.assertEquals((int)results1[0], (int)10);
        LocaleConvertUtilsTestCase.assertEquals((int)results1[1], (int)20);
        LocaleConvertUtilsTestCase.assertEquals((int)results1[2], (int)30);
        String[] values2 = new String[]{"100", "200", "300"};
        value = LocaleConvertUtils.convert((String[])values2, shape.getClass());
        LocaleConvertUtilsTestCase.assertEquals(shape.getClass(), value.getClass());
        int[] results2 = (int[])value;
        LocaleConvertUtilsTestCase.assertEquals((int)results2[0], (int)100);
        LocaleConvertUtilsTestCase.assertEquals((int)results2[1], (int)200);
        LocaleConvertUtilsTestCase.assertEquals((int)results2[2], (int)300);
    }

    public void fixmetestPositiveIntegerArray() {
        LocaleConvertUtilsTestCase.fail((String)"Array conversions not implemented yet.");
        Object value = null;
        int[] intArray = new int[]{};
        int[] intArray1 = new int[]{0};
        int[] intArray2 = new int[]{0, 10};
        value = LocaleConvertUtils.convert((String)"{  }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = LocaleConvertUtils.convert((String)"0", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = LocaleConvertUtils.convert((String)" 0 ", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = LocaleConvertUtils.convert((String)"{ 0 }", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = LocaleConvertUtils.convert((String)"0,10", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"0 10", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{0,10}", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{0 10}", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{ 0, 10 }", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = LocaleConvertUtils.convert((String)"{ 0 10 }", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
    }

    public void testPositiveScalar() {
        Object value = null;
        value = LocaleConvertUtils.convert((String)"123", Byte.TYPE);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        LocaleConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)123);
        value = LocaleConvertUtils.convert((String)"123", Byte.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        LocaleConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)123);
        value = LocaleConvertUtils.convert((String)("123" + this.m_decimalSeparator + "456"), Double.TYPE);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Double));
        LocaleConvertUtilsTestCase.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = LocaleConvertUtils.convert((String)("123" + this.m_decimalSeparator + "456"), Double.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Double));
        LocaleConvertUtilsTestCase.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = LocaleConvertUtils.convert((String)("123" + this.m_decimalSeparator + "456"), Float.TYPE);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Float));
        LocaleConvertUtilsTestCase.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = LocaleConvertUtils.convert((String)("123" + this.m_decimalSeparator + "456"), Float.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Float));
        LocaleConvertUtilsTestCase.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = LocaleConvertUtils.convert((String)"123", Integer.TYPE);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Integer));
        LocaleConvertUtilsTestCase.assertEquals((int)((Integer)value), (int)123);
        value = LocaleConvertUtils.convert((String)"123", Integer.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Integer));
        LocaleConvertUtilsTestCase.assertEquals((int)((Integer)value), (int)123);
        value = LocaleConvertUtils.convert((String)"123", Long.TYPE);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Long));
        LocaleConvertUtilsTestCase.assertEquals((long)((Long)value), (long)123L);
        value = LocaleConvertUtils.convert((String)"123456", Long.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Long));
        LocaleConvertUtilsTestCase.assertEquals((long)((Long)value), (long)123456L);
        String input = null;
        input = "2002-03-17";
        value = LocaleConvertUtils.convert((String)input, Date.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Date));
        LocaleConvertUtilsTestCase.assertEquals((String)input, (String)value.toString());
        input = "20:30:40";
        value = LocaleConvertUtils.convert((String)input, Time.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Time));
        LocaleConvertUtilsTestCase.assertEquals((String)input, (String)value.toString());
        input = "2002-03-17 20:30:40.0";
        value = LocaleConvertUtils.convert((String)input, Timestamp.class);
        LocaleConvertUtilsTestCase.assertTrue((boolean)(value instanceof Timestamp));
        LocaleConvertUtilsTestCase.assertEquals((String)input, (String)value.toString());
    }

    public void fixmetestPositiveStringArray() {
        LocaleConvertUtilsTestCase.fail((String)"Array conversions not implemented yet.");
        Object value = null;
        String[] stringArray = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "de,f"};
        value = LocaleConvertUtils.convert((String)"", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)" ", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)"{}", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)"{  }", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = LocaleConvertUtils.convert((String)"abc", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"{abc}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"\"abc\"", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"{\"abc\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"'abc'", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"{'abc'}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = LocaleConvertUtils.convert((String)"abc 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"{abc, 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"\"abc\",\"de,f\"", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"{\"abc\" 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"'abc' 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = LocaleConvertUtils.convert((String)"{'abc', \"de,f\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
    }

    public void testConvertStringLocaleNull() {
        Object result = null;
        try {
            result = LocaleConvertUtils.convert((String)"123", Integer.class, (Locale)null, (String)"#,###");
        }
        catch (Exception e) {
            e.printStackTrace();
            LocaleConvertUtilsTestCase.fail((String)("Threw: " + e));
        }
        LocaleConvertUtilsTestCase.assertNotNull((String)"Null Result", (Object)result);
        LocaleConvertUtilsTestCase.assertEquals((String)"Integer Type", Integer.class, result.getClass());
        LocaleConvertUtilsTestCase.assertEquals((String)"Integer Value", (Object)new Integer(123), (Object)result);
    }

    public void testConvertStringArrayLocaleNull() {
        Object result = null;
        try {
            result = LocaleConvertUtils.convert((String[])new String[]{"123"}, Integer[].class, (Locale)null, (String)"#,###");
        }
        catch (Exception e) {
            e.printStackTrace();
            LocaleConvertUtilsTestCase.fail((String)("Threw: " + e));
        }
        LocaleConvertUtilsTestCase.assertNotNull((String)"Null Result", (Object)result);
        LocaleConvertUtilsTestCase.assertEquals((String)"Integer Array Type", Integer[].class, result.getClass());
        LocaleConvertUtilsTestCase.assertEquals((String)"Integer Array Length", (int)1, (int)((Integer[])result).length);
        LocaleConvertUtilsTestCase.assertEquals((String)"Integer Array Value", (Object)new Integer(123), (Object)((Integer[])result)[0]);
    }

    public void testDefaultToStringConversionUnsupportedType() {
        Integer value = 20131101;
        LocaleConvertUtilsTestCase.assertEquals((String)"Wrong result", (Object)value.toString(), (Object)LocaleConvertUtils.convert((String)value.toString(), ((Object)((Object)this)).getClass()));
    }

    private void checkIntegerArray(Object value, int[] intArray) {
        LocaleConvertUtilsTestCase.assertNotNull((String)"Returned value is not null", (Object)value);
        LocaleConvertUtilsTestCase.assertEquals((String)"Returned value is int[]", intArray.getClass(), value.getClass());
        int[] results = (int[])value;
        LocaleConvertUtilsTestCase.assertEquals((String)"Returned array length", (int)intArray.length, (int)results.length);
        for (int i = 0; i < intArray.length; ++i) {
            LocaleConvertUtilsTestCase.assertEquals((String)("Returned array value " + i), (int)intArray[i], (int)results[i]);
        }
    }

    private void checkStringArray(Object value, String[] stringArray) {
        LocaleConvertUtilsTestCase.assertNotNull((String)"Returned value is not null", (Object)value);
        LocaleConvertUtilsTestCase.assertEquals((String)"Returned value is String[]", stringArray.getClass(), value.getClass());
        String[] results = (String[])value;
        LocaleConvertUtilsTestCase.assertEquals((String)"Returned array length", (int)stringArray.length, (int)results.length);
        for (int i = 0; i < stringArray.length; ++i) {
            LocaleConvertUtilsTestCase.assertEquals((String)("Returned array value " + i), (String)stringArray[i], (String)results[i]);
        }
    }
}

