/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.BaseLocaleConverterTestCase;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateLocaleConverterTestCase
extends BaseLocaleConverterTestCase {
    private final Log log = LogFactory.getLog(DateLocaleConverterTestCase.class);
    protected String localizedDatePattern;
    protected String localizedDateValue;
    protected String localizedShortDateValue;
    protected String defaultDatePattern;
    protected String defaultDateValue;
    protected String defaultShortDateValue;
    protected boolean validLocalDateSymbols;

    public DateLocaleConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        String version = System.getProperty("java.specification.version");
        this.log.debug((Object)("JDK Version " + version));
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            this.expectedValue = format.parse("20041001");
            this.defaultValue = format.parse("19670316");
        }
        catch (Exception ex) {
            this.log.error((Object)"Error creating expected/default dates", (Throwable)ex);
        }
        this.defaultLocale = Locale.US;
        this.defaultDatePattern = "d MMMM yyyy";
        this.defaultDateValue = "1 October 2004";
        this.defaultShortDateValue = "10/01/04";
        this.localizedLocale = new Locale("de", "AT");
        this.localizedDatePattern = "t MMMM uuuu";
        this.localizedDateValue = "1 Oktober 2004";
        this.localizedShortDateValue = "01.10.04";
        String expectedChars = "GuMtkHmsSEDFwWahKzZ";
        DateFormatSymbols localizedSymbols = new DateFormatSymbols(this.localizedLocale);
        String localChars = localizedSymbols.getLocalPatternChars();
        int lth = localChars.length() > expectedChars.length() ? expectedChars.length() : (localChars.length() < expectedChars.length() ? localChars.length() : expectedChars.length());
        this.validLocalDateSymbols = expectedChars.substring(0, lth).equals(localChars.substring(0, lth));
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testSetLenient() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy", Locale.UK);
        dateFormat.setLenient(false);
        try {
            dateFormat.parse("Feb 10, 2001");
        }
        catch (ParseException e) {
            DateLocaleConverterTestCase.fail((String)("Could not parse date (1) - " + e.getMessage()));
        }
        try {
            dateFormat.parse("Feb 31, 2001");
            DateLocaleConverterTestCase.fail((String)"Parsed illegal date (1)");
        }
        catch (ParseException e) {
            // empty catch block
        }
        dateFormat.setLenient(true);
        try {
            dateFormat.parse("Feb 10, 2001");
        }
        catch (ParseException e) {
            DateLocaleConverterTestCase.fail((String)("Could not parse date (2) - " + e.getMessage()));
        }
        try {
            dateFormat.parse("Feb 31, 2001");
        }
        catch (ParseException e) {
            DateLocaleConverterTestCase.fail((String)("Could not parse date (3) - " + e.getMessage()));
        }
        DateLocaleConverter converter = new DateLocaleConverter(Locale.UK, "MMM dd, yyyy");
        converter.setLenient(false);
        DateLocaleConverterTestCase.assertEquals((String)"Set lenient failed", (boolean)converter.isLenient(), (boolean)false);
        try {
            converter.convert((Object)"Feb 10, 2001");
        }
        catch (ConversionException e) {
            DateLocaleConverterTestCase.fail((String)("Could not parse date (4) - " + e.getMessage()));
        }
        try {
            converter.convert((Object)"Feb 31, 2001");
            DateLocaleConverterTestCase.assertEquals((String)"Set lenient failed", (boolean)converter.isLenient(), (boolean)false);
            DateLocaleConverterTestCase.fail((String)"Parsed illegal date (2)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        converter.setLenient(true);
        DateLocaleConverterTestCase.assertEquals((String)"Set lenient failed", (boolean)converter.isLenient(), (boolean)true);
        try {
            converter.convert((Object)"Feb 10, 2001");
        }
        catch (ConversionException e) {
            DateLocaleConverterTestCase.fail((String)("Could not parse date (5) - " + e.getMessage()));
        }
        try {
            converter.convert((Object)"Feb 31, 2001");
        }
        catch (ConversionException e) {
            DateLocaleConverterTestCase.fail((String)("Could not parse date (6) - " + e.getMessage()));
        }
    }

    public void testConstructorMain() {
        if (!this.validLocalDateSymbols) {
            this.log.error((Object)"Invalid locale symbols *** skipping testConstructorMain() **");
            return;
        }
        this.converter = new DateLocaleConverter(this.defaultValue, this.localizedLocale, this.localizedDatePattern, true);
        this.convertValueNoPattern(this.converter, "(A)", this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedDateValue, this.localizedDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultDateValue, this.defaultValue);
        this.convertValueWithPattern(this.converter, "(B)", this.localizedDateValue, this.defaultDatePattern, this.defaultValue);
        this.converter = new DateLocaleConverter(this.defaultValue, this.localizedLocale, this.defaultDatePattern, false);
        this.convertValueNoPattern(this.converter, "(C)", this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    public void testConstructor_2() {
        this.converter = new DateLocaleConverter();
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_3() {
        this.converter = new DateLocaleConverter(true);
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_4() {
        this.converter = new DateLocaleConverter(this.localizedLocale);
        this.convertValueNoPattern(this.converter, this.localizedShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_5() {
        if (!this.validLocalDateSymbols) {
            this.log.error((Object)"Invalid locale symbols *** skipping testConstructor_5() **");
            return;
        }
        this.converter = new DateLocaleConverter(this.localizedLocale, true);
        this.convertValueNoPattern(this.converter, this.localizedShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.localizedDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_6() {
        this.converter = new DateLocaleConverter(this.localizedLocale, this.defaultDatePattern);
        this.convertValueNoPattern(this.converter, this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_7() {
        if (!this.validLocalDateSymbols) {
            this.log.error((Object)"Invalid locale symbols *** skipping testConstructor_7() **");
            return;
        }
        this.converter = new DateLocaleConverter(this.localizedLocale, this.localizedDatePattern, true);
        this.convertValueNoPattern(this.converter, this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.localizedDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_8() {
        this.converter = new DateLocaleConverter(this.defaultValue);
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testConstructor_9() {
        this.converter = new DateLocaleConverter(this.defaultValue, true);
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testInvalidDate() {
        this.converter = new DateLocaleConverter(this.defaultLocale);
        try {
            this.converter.convert((Object)"01/10/2004", "dd-MM-yyyy");
        }
        catch (ConversionException e) {
            DateLocaleConverterTestCase.assertEquals((String)"Parse Error", (String)"Error parsing date '01/10/2004' at position=2", (String)e.getMessage());
        }
        try {
            this.converter.convert((Object)"01-10-2004X", "dd-MM-yyyy");
        }
        catch (ConversionException e) {
            DateLocaleConverterTestCase.assertEquals((String)"Parse Length", (String)"Date '01-10-2004X' contains unparsed characters from position=10", (String)e.getMessage());
        }
    }

    public void testDateObject() {
        this.converter = new DateLocaleConverter(this.defaultLocale);
        DateLocaleConverterTestCase.assertEquals((String)"java.util.Date", (Object)this.expectedValue, (Object)this.converter.convert(this.expectedValue));
    }

    public void testCalendarObject() {
        this.converter = new DateLocaleConverter(this.defaultLocale);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.expectedValue);
        DateLocaleConverterTestCase.assertEquals((String)"java.util.Calendar", (Object)this.expectedValue, (Object)this.converter.convert((Object)calendar));
    }
}

