/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.ClassConverter;

public class ClassConverterTestCase
extends TestCase {
    public ClassConverterTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(ClassConverterTestCase.class);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testConvertToString() {
        ClassConverter converter = new ClassConverter();
        ClassConverterTestCase.assertEquals((String)"Class Test", (String)"java.lang.Integer", (String)((String)converter.convert(String.class, Integer.class)));
        ClassConverterTestCase.assertEquals((String)"Value Test", (String)"foo", (String)((String)converter.convert(String.class, (Object)"foo")));
        ClassConverterTestCase.assertEquals((String)"Value Test", (String)"bar", (String)((String)converter.convert(String.class, (Object)new StringBuilder("bar"))));
        ClassConverterTestCase.assertEquals((String)"Null Test", null, (String)((String)converter.convert(String.class, null)));
    }

    public void testConvertToClass() {
        ClassConverter converter = new ClassConverter();
        ClassConverterTestCase.assertEquals((String)"Class Test", Integer.class, (Object)converter.convert(Class.class, Integer.class));
        ClassConverterTestCase.assertEquals((String)"String Test", Integer.class, (Object)converter.convert(Class.class, (Object)"java.lang.Integer"));
        ClassConverterTestCase.assertEquals((String)"StringBuilder Test", Integer.class, (Object)converter.convert(Class.class, (Object)new StringBuilder("java.lang.Integer")));
        try {
            converter.convert(Class.class, (Object)new Integer(6));
            ClassConverterTestCase.fail((String)"Expected invalid value to fail");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            converter.convert(Class.class, null);
            ClassConverterTestCase.fail((String)"Expected null value to fail");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testConvertToClassDefault() {
        ClassConverter converter = new ClassConverter(Object.class);
        ClassConverterTestCase.assertEquals((String)"Invalid Test", Object.class, (Object)converter.convert(Class.class, (Object)new Integer(6)));
        ClassConverterTestCase.assertEquals((String)"Null Test", Object.class, (Object)converter.convert(Class.class, null));
    }

    public void testConvertToClassDefaultNull() {
        ClassConverter converter = new ClassConverter(null);
        ClassConverterTestCase.assertEquals((String)"Invalid Test", null, (Object)converter.convert(Class.class, (Object)new Integer(6)));
        ClassConverterTestCase.assertEquals((String)"Null Test", null, (Object)converter.convert(Class.class, null));
    }

    public void testArray() {
        ClassConverter converter = new ClassConverter();
        ClassConverterTestCase.assertEquals((String)"Array to String", (String)"[Ljava.lang.Boolean;", (String)((String)converter.convert(String.class, Boolean[].class)));
    }

    public void testInvalid() {
        ClassConverter converter = new ClassConverter();
        try {
            converter.convert(Class.class, (Object)"foo.bar");
            ClassConverterTestCase.fail((String)"Invalid class name, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testUnsupportedTargetType() {
        ClassConverter converter = new ClassConverter();
        try {
            converter.convert(Integer.class, (Object)((Object)((Object)this)).getClass().getName());
            ClassConverterTestCase.fail((String)"Invalid target class not detected!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

