/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateTimeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateConverterTestBase
extends TestCase {
    public DateConverterTestBase(String name) {
        super(name);
    }

    protected abstract DateTimeConverter makeConverter();

    protected abstract DateTimeConverter makeConverter(Object var1);

    protected abstract Class<?> getExpectedType();

    protected abstract Object toType(Calendar var1);

    public void testConvertNull() {
        try {
            this.makeConverter().convert(this.getExpectedType(), null);
            DateConverterTestBase.fail((String)"Expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testConvertDate() {
        String[] message = new String[]{"from Date", "from Calendar", "from SQL Date", "from SQL Time", "from SQL Timestamp"};
        long now = System.currentTimeMillis();
        Object[] date = new Object[]{new Date(now), new GregorianCalendar(), new java.sql.Date(now), new Time(now), new Timestamp(now)};
        ((GregorianCalendar)date[1]).setTime(new Date(now));
        for (int i = 0; i < date.length; ++i) {
            Object val = this.makeConverter().convert(this.getExpectedType(), date[i]);
            DateConverterTestBase.assertNotNull((String)("Convert " + message[i] + " should not be null"), (Object)val);
            DateConverterTestBase.assertTrue((String)("Convert " + message[i] + " should return a " + this.getExpectedType().getName()), (boolean)this.getExpectedType().isInstance(val));
            DateConverterTestBase.assertEquals((String)("Convert " + message[i] + " should return a " + date[0]), (long)now, (long)this.getTimeInMillis(val));
        }
    }

    public void testDefaultType() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter converter = this.makeConverter();
        converter.setPattern(pattern);
        String testString = "2006-10-29";
        Calendar calendar = this.toCalendar(testString, pattern, null);
        Object expected = this.toType(calendar);
        Object result = converter.convert(null, (Object)testString);
        if (this.getExpectedType().equals(Calendar.class)) {
            DateConverterTestBase.assertTrue((String)"TYPE ", (boolean)this.getExpectedType().isAssignableFrom(result.getClass()));
        } else {
            DateConverterTestBase.assertEquals((String)"TYPE ", this.getExpectedType(), result.getClass());
        }
        DateConverterTestBase.assertEquals((String)"VALUE ", (Object)expected, (Object)result);
    }

    public void testDefaultStringToTypeConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        try {
            converter.convert(this.getExpectedType(), (Object)"2006-10-23");
            DateConverterTestBase.fail((String)"Expected Conversion exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testStringConversion() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter converter = this.makeConverter();
        converter.setPattern(pattern);
        String expected = "2006-10-29";
        Calendar calendar = this.toCalendar(expected, pattern, null);
        this.stringConversion((Converter)converter, expected, this.toType(calendar));
        this.stringConversion((Converter)converter, expected, calendar);
        this.stringConversion((Converter)converter, expected, this.toDate(calendar));
        this.stringConversion((Converter)converter, expected, this.toSqlDate(calendar));
        this.stringConversion((Converter)converter, expected, this.toSqlTimestamp(calendar));
        this.stringConversion((Converter)converter, expected, this.toSqlTime(calendar));
        this.stringConversion((Converter)converter, null, null);
        this.stringConversion((Converter)converter, "", "");
    }

    public void testPatternNoDefault() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter converter = this.makeConverter();
        converter.setPattern(pattern);
        String testString = "2006-10-29";
        Calendar calendar = this.toCalendar(testString, pattern, null);
        Object expected = this.toType(calendar);
        this.validConversion((Converter)converter, expected, testString);
        this.validConversion((Converter)converter, expected, calendar);
        this.validConversion((Converter)converter, expected, this.toDate(calendar));
        this.validConversion((Converter)converter, expected, this.toSqlDate(calendar));
        this.validConversion((Converter)converter, expected, this.toSqlTimestamp(calendar));
        this.validConversion((Converter)converter, expected, this.toSqlTime(calendar));
        this.invalidConversion((Converter)converter, null);
        this.invalidConversion((Converter)converter, "");
        this.invalidConversion((Converter)converter, "2006-10-2X");
        this.invalidConversion((Converter)converter, "2006/10/01");
        this.invalidConversion((Converter)converter, "02/10/2006");
        this.invalidConversion((Converter)converter, "02/10/06");
        this.invalidConversion((Converter)converter, new Integer(2));
    }

    public void testPatternDefault() {
        String pattern = "yyyy-MM-dd";
        Object defaultValue = this.toType("2000-01-01", pattern, null);
        DateConverterTestBase.assertNotNull((String)"Check default date", (Object)defaultValue);
        DateTimeConverter converter = this.makeConverter(defaultValue);
        converter.setPattern(pattern);
        String testString = "2006-10-29";
        Object expected = this.toType(testString, pattern, null);
        this.validConversion((Converter)converter, expected, testString);
        this.validConversion((Converter)converter, defaultValue, null);
        this.validConversion((Converter)converter, defaultValue, "");
        this.validConversion((Converter)converter, defaultValue, "2006-10-2X");
        this.validConversion((Converter)converter, defaultValue, "2006/10/01");
        this.validConversion((Converter)converter, defaultValue, "02/10/06");
        this.validConversion((Converter)converter, defaultValue, new Integer(2));
    }

    public void testPatternNullDefault() {
        String pattern = "yyyy-MM-dd";
        Object defaultValue = null;
        DateTimeConverter converter = this.makeConverter(defaultValue);
        converter.setPattern(pattern);
        String testString = "2006-10-29";
        Object expected = this.toType(testString, pattern, null);
        this.validConversion((Converter)converter, expected, testString);
        this.validConversion((Converter)converter, defaultValue, null);
        this.validConversion((Converter)converter, defaultValue, "");
        this.validConversion((Converter)converter, defaultValue, "2006-10-2X");
        this.validConversion((Converter)converter, defaultValue, "2006/10/01");
        this.validConversion((Converter)converter, defaultValue, "02/10/06");
        this.validConversion((Converter)converter, defaultValue, new Integer(2));
    }

    public void testMultiplePatterns() {
        String testString = null;
        Object expected = null;
        String[] patterns = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};
        DateTimeConverter converter = this.makeConverter();
        converter.setPatterns(patterns);
        testString = "2006-10-28";
        expected = this.toType(testString, patterns[0], null);
        this.validConversion((Converter)converter, expected, testString);
        testString = "2006/10/18";
        expected = this.toType(testString, patterns[1], null);
        this.validConversion((Converter)converter, expected, testString);
        this.invalidConversion((Converter)converter, "17/03/2006");
        this.invalidConversion((Converter)converter, "17.03.2006");
    }

    public void testLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String pattern = "M/d/yy";
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        String testString = "10/28/06";
        Object expected = this.toType(testString, pattern, null);
        this.validConversion((Converter)converter, expected, testString);
        this.invalidConversion((Converter)converter, null);
        this.invalidConversion((Converter)converter, "");
        this.invalidConversion((Converter)converter, "2006-10-2X");
        this.invalidConversion((Converter)converter, "10.28.06");
        this.invalidConversion((Converter)converter, "10-28-06");
        this.invalidConversion((Converter)converter, new Integer(2));
        Locale.setDefault(defaultLocale);
    }

    public void testInvalidType() {
        DateTimeConverter converter = this.makeConverter();
        try {
            converter.convert(Character.class, (Object)new Date());
            DateConverterTestBase.fail((String)"Requested Character.class conversion, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    void validConversion(Converter converter, Object expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "'";
        try {
            Object result = converter.convert(this.getExpectedType(), value);
            Class<?> resultType = result == null ? null : result.getClass();
            Class<?> expectType = expected == null ? null : expected.getClass();
            DateConverterTestBase.assertEquals((String)("TYPE " + msg), expectType, resultType);
            DateConverterTestBase.assertEquals((String)("VALUE " + msg), (Object)expected, (Object)result);
        }
        catch (Exception ex) {
            DateConverterTestBase.fail((String)(msg + " threw " + ex.toString()));
        }
    }

    void stringConversion(Converter converter, String expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "' to String";
        try {
            Object result = converter.convert(String.class, value);
            Class<?> resultType = result == null ? null : result.getClass();
            Class<?> expectType = expected == null ? null : expected.getClass();
            DateConverterTestBase.assertEquals((String)("TYPE " + msg), expectType, resultType);
            DateConverterTestBase.assertEquals((String)("VALUE " + msg), (Object)expected, (Object)result);
        }
        catch (Exception ex) {
            DateConverterTestBase.fail((String)(msg + " threw " + ex.toString()));
        }
    }

    void invalidConversion(Converter converter, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "'";
        try {
            Object result = converter.convert(this.getExpectedType(), value);
            DateConverterTestBase.fail((String)(msg + ", expected ConversionException, but result = '" + result + "'"));
        }
        catch (ConversionException ex) {
            // empty catch block
        }
    }

    Object toType(String value, String pattern, Locale locale) {
        Calendar calendar = this.toCalendar(value, pattern, locale);
        return this.toType(calendar);
    }

    Calendar toCalendar(String value, String pattern, Locale locale) {
        Calendar calendar = null;
        try {
            SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
            format.setLenient(false);
            format.parse(value);
            calendar = format.getCalendar();
        }
        catch (Exception e) {
            DateConverterTestBase.fail((String)("Error creating Calendar value ='" + value + ", pattern='" + pattern + "' " + e.toString()));
        }
        return calendar;
    }

    Date toDate(Calendar calendar) {
        return calendar.getTime();
    }

    java.sql.Date toSqlDate(Calendar calendar) {
        return new java.sql.Date(this.getTimeInMillis(calendar));
    }

    Time toSqlTime(Calendar calendar) {
        return new Time(this.getTimeInMillis(calendar));
    }

    Timestamp toSqlTimestamp(Calendar calendar) {
        return new Timestamp(this.getTimeInMillis(calendar));
    }

    long getTimeInMillis(Object date) {
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return timeInMillis += (long)(timestamp.getNanos() / 1000000);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime().getTime();
        }
        return ((Date)date).getTime();
    }
}

