/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.memoryleaktests;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.WrapDynaClass;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtils;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;

public class MemoryLeakTestCase
extends TestCase {
    public void testPropertyUtilsBean_descriptorsCache_memoryLeak() throws Exception {
        if (this.isPre15JVM()) {
            return;
        }
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MemoryLeakTestCase.assertEquals((Object)"initialValue", (Object)PropertyUtils.getProperty(bean, (String)"name"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("PropertyUtilsBean descriptorsCache", className);
        }
        MemoryLeakTestCase.assertNull((String)"PropertyUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    public void testPropertyUtilsBean_mappedDescriptorsCache_memoryLeak() throws Exception {
        if (this.isPre15JVM()) {
            return;
        }
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MemoryLeakTestCase.assertEquals((Object)"Second Value", (Object)PropertyUtils.getProperty(bean, (String)"mappedProperty(Second Key)"));
        PropertyUtils.setProperty(bean, (String)"mappedProperty(Second Key)", (Object)"New Second Value");
        MemoryLeakTestCase.assertEquals((Object)"New Second Value", (Object)PropertyUtils.getProperty(bean, (String)"mappedProperty(Second Key)"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("PropertyUtilsBean mappedDescriptorsCache", className);
        }
        MemoryLeakTestCase.assertNull((String)"PropertyUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    public void testMappedPropertyDescriptor_MappedMethodReference1() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotNull((String)"Bean is null", bean);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MappedPropertyDescriptor descriptor = new MappedPropertyDescriptor("mappedProperty", beanClass);
        MemoryLeakTestCase.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        MemoryLeakTestCase.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        MemoryLeakTestCase.assertEquals((String)"1-Read Method name", (String)"getMappedProperty", (String)descriptor.getMappedReadMethod().getName());
        MemoryLeakTestCase.assertEquals((String)"1-Read Write name", (String)"setMappedProperty", (String)descriptor.getMappedWriteMethod().getName());
        this.forceGarbageCollection();
        MemoryLeakTestCase.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        MemoryLeakTestCase.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        MemoryLeakTestCase.assertEquals((String)"1-Read Method name", (String)"getMappedProperty", (String)descriptor.getMappedReadMethod().getName());
        MemoryLeakTestCase.assertEquals((String)"1-Read Write name", (String)"setMappedProperty", (String)descriptor.getMappedWriteMethod().getName());
        this.clearAllBeanUtilsCaches();
    }

    public void testMappedPropertyDescriptor_MappedMethodReference2() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotNull((String)"Bean is null", bean);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MappedPropertyDescriptor descriptor = new MappedPropertyDescriptor("mappedProperty", beanClass);
        MemoryLeakTestCase.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        MemoryLeakTestCase.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        MemoryLeakTestCase.assertEquals((String)"1-Read Method name", (String)"getMappedProperty", (String)descriptor.getMappedReadMethod().getName());
        MemoryLeakTestCase.assertEquals((String)"1-Read Write name", (String)"setMappedProperty", (String)descriptor.getMappedWriteMethod().getName());
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        MemoryLeakTestCase.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        MemoryLeakTestCase.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        MemoryLeakTestCase.assertEquals((String)"1-Read Method name", (String)"getMappedProperty", (String)descriptor.getMappedReadMethod().getName());
        MemoryLeakTestCase.assertEquals((String)"1-Read Write name", (String)"setMappedProperty", (String)descriptor.getMappedWriteMethod().getName());
        this.clearAllBeanUtilsCaches();
    }

    public void testMethodUtils_cache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MemoryLeakTestCase.assertEquals((Object)"initialValue", (Object)MethodUtils.invokeExactMethod(bean, (String)"getName", (Object[])new Object[0]));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("MethodUtils cache", className);
        }
        MemoryLeakTestCase.assertNull((String)"MethodUtils is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    public void testWrapDynaClass_dynaClasses_memoryLeak() throws Exception {
        if (this.isPre15JVM()) {
            return;
        }
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        WrapDynaBean wrapDynaBean = new WrapDynaBean(bean);
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MemoryLeakTestCase.assertEquals((Object)"initialValue", (Object)wrapDynaBean.get("name"));
        loader = null;
        beanClass = null;
        bean = null;
        wrapDynaBean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("WrapDynaClass dynaClasses", className);
        }
        MemoryLeakTestCase.assertNull((String)"WrapDynaClass is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    public void testConvertUtilsBean_converters_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        ConvertUtils.register((Converter)new IntegerConverter(), beanClass);
        MemoryLeakTestCase.assertEquals((Object)"12345", (Object)ConvertUtils.convert(bean, String.class));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("ConvertUtilsBean converters", className);
        }
        MemoryLeakTestCase.assertNull((String)"ConvertUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    public void testLocaleConvertUtilsBean_converters_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass(className);
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        MemoryLeakTestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        MemoryLeakTestCase.assertNotNull((String)"BeanClass is null", beanClass);
        MemoryLeakTestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        MemoryLeakTestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        LocaleConvertUtils.register((LocaleConverter)new IntegerLocaleConverter(Locale.US, false), beanClass, (Locale)Locale.US);
        MemoryLeakTestCase.assertEquals((Object)new Integer(12345), (Object)LocaleConvertUtils.convert((String)bean.toString(), Integer.class, (Locale)Locale.US, (String)"#,###"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("LocaleConvertUtilsBean converters", className);
        }
        MemoryLeakTestCase.assertNull((String)"LocaleConvertUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    private void clearAllBeanUtilsCaches() {
        BeanUtilsBean.getInstance().getPropertyUtils().clearDescriptors();
        LocaleBeanUtilsBean.getInstance().getPropertyUtils().clearDescriptors();
        MethodUtils.clearCache();
        WrapDynaClass.clear();
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean());
        LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)new LocaleBeanUtilsBean());
    }

    private void forceGarbageCollection() throws Exception {
        SoftReference<Object> ref = new SoftReference<Object>(new Object());
        int count = 0;
        while (ref.get() != null && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (ref.get() != null) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            list.clear();
            list = null;
            System.gc();
            Thread.sleep(1000L);
        }
        if (ref.get() != null) {
            throw new IllegalStateException("Your JVM is not releasing SoftReference, try running the testcase with less memory (-Xmx)");
        }
    }

    private static URLClassLoader newClassLoader() throws MalformedURLException {
        String dataFilePath = MemoryLeakTestCase.class.getResource("pojotests").getFile();
        String location = "file://" + dataFilePath.substring(0, dataFilePath.length() - "org.apache.commons.beanutils.memoryleaktests.pojotests".length());
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < location.length(); ++i) {
            if (location.charAt(i) == '\\') {
                newString.append("/");
                continue;
            }
            newString.append(location.charAt(i));
        }
        String classLocation = newString.toString();
        URLClassLoader theLoader = URLClassLoader.newInstance(new URL[]{new URL(classLocation)}, null);
        return theLoader;
    }

    private void profilerLeakReport(String test, String className) {
    }

    private boolean isPre15JVM() {
        String version = System.getProperty("java.specification.version");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        if (tokenizer.nextToken().equals("1")) {
            String minorVersion = tokenizer.nextToken();
            if (minorVersion.equals("0")) {
                return true;
            }
            if (minorVersion.equals("1")) {
                return true;
            }
            if (minorVersion.equals("2")) {
                return true;
            }
            if (minorVersion.equals("3")) {
                return true;
            }
            if (minorVersion.equals("4")) {
                return true;
            }
        }
        return false;
    }

    private String getMemoryStats() {
        DecimalFormat fmt = new DecimalFormat("#,##0");
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory() / 1024L;
        long total = runtime.totalMemory() / 1024L;
        long used = total - free;
        return "MEMORY - Total: " + fmt.format(total) + "k " + "Used: " + fmt.format(used) + "k " + "Free: " + fmt.format(free) + "k";
    }
}

