/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.beanutils.IntrospectionContext;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;

public class SuppressPropertiesBeanIntrospectorTestCase
extends TestCase {
    public void testInitNoPropertyNames() {
        try {
            new SuppressPropertiesBeanIntrospector(null);
            SuppressPropertiesBeanIntrospectorTestCase.fail((String)"Missing properties not detected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemovePropertiesDuringIntrospection() throws IntrospectionException {
        String[] properties = new String[]{"test", "other", "oneMore"};
        SuppressPropertiesBeanIntrospector introspector = new SuppressPropertiesBeanIntrospector(Arrays.asList(properties));
        IntrospectionContextTestImpl context = new IntrospectionContextTestImpl();
        introspector.introspect((IntrospectionContext)context);
        SuppressPropertiesBeanIntrospectorTestCase.assertEquals((String)"Wrong number of removed properties", (int)properties.length, (int)context.getRemovedProperties().size());
        for (String property : properties) {
            SuppressPropertiesBeanIntrospectorTestCase.assertTrue((String)("Property not removed: " + property), (boolean)context.getRemovedProperties().contains(property));
        }
    }

    public void testPropertyNamesDefensiveCopy() throws IntrospectionException {
        HashSet<String> properties = new HashSet<String>();
        properties.add("prop1");
        SuppressPropertiesBeanIntrospector introspector = new SuppressPropertiesBeanIntrospector(properties);
        properties.add("prop2");
        IntrospectionContextTestImpl context = new IntrospectionContextTestImpl();
        introspector.introspect((IntrospectionContext)context);
        SuppressPropertiesBeanIntrospectorTestCase.assertEquals((String)"Wrong number of removed properties", (int)1, (int)context.getRemovedProperties().size());
        SuppressPropertiesBeanIntrospectorTestCase.assertTrue((String)"Wrong removed property", (boolean)context.getRemovedProperties().contains("prop1"));
    }

    public void testGetSuppressedPropertiesModify() {
        SuppressPropertiesBeanIntrospector introspector = new SuppressPropertiesBeanIntrospector(Arrays.asList("p1", "p2"));
        Set properties = introspector.getSuppressedProperties();
        try {
            properties.add("anotherProperty");
            SuppressPropertiesBeanIntrospectorTestCase.fail((String)"Could modify properties");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntrospectionContextTestImpl
    implements IntrospectionContext {
        private final Set<String> removedProperties = new HashSet<String>();

        private IntrospectionContextTestImpl() {
        }

        public Set<String> getRemovedProperties() {
            return this.removedProperties;
        }

        public Class<?> getTargetClass() {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public void addPropertyDescriptor(PropertyDescriptor desc) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public void addPropertyDescriptors(PropertyDescriptor[] descriptors) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public boolean hasProperty(String name) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public PropertyDescriptor getPropertyDescriptor(String name) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public void removePropertyDescriptor(String name) {
            this.removedProperties.add(name);
        }

        public Set<String> propertyNames() {
            throw new UnsupportedOperationException("Unexpected method call!");
        }
    }
}

