/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.AlphaBean;
import org.apache.commons.beanutils.BasicDynaBeanTestCase;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.FluentIntrospectionTestBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.WrapDynaClass;

public class WrapDynaBeanTestCase
extends BasicDynaBeanTestCase {
    public WrapDynaBeanTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.bean = new WrapDynaBean((Object)new TestBean());
    }

    public static Test suite() {
        return new TestSuite(WrapDynaBeanTestCase.class);
    }

    public void tearDown() {
        this.bean = null;
    }

    public void testSimpleProperties() {
        this.checkSimplePropertyAccess();
    }

    private void checkSimplePropertyAccess() {
        try {
            this.bean.get("invalidProperty");
            WrapDynaBeanTestCase.fail((String)"Invalid get should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException t) {
            // empty catch block
        }
        try {
            this.bean.set("invalidProperty", (Object)"XYZ");
            WrapDynaBeanTestCase.fail((String)"Invalid set should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException t) {
            // empty catch block
        }
        String testValue = "Original Value";
        String testProperty = "stringProperty";
        TestBean instance = (TestBean)((WrapDynaBean)this.bean).getInstance();
        instance.setStringProperty(testValue);
        WrapDynaBeanTestCase.assertEquals((String)"Check String property", (String)testValue, (String)instance.getStringProperty());
        try {
            testValue = "Some new value";
            this.bean.set(testProperty, (Object)testValue);
            WrapDynaBeanTestCase.assertEquals((String)"Test Set", (String)testValue, (String)instance.getStringProperty());
            WrapDynaBeanTestCase.assertEquals((String)"Test Get", (Object)testValue, (Object)this.bean.get(testProperty));
        }
        catch (IllegalArgumentException t) {
            WrapDynaBeanTestCase.fail((String)("Get threw exception: " + t));
        }
    }

    public void testIndexedProperties() {
        try {
            this.bean.get("invalidProperty", 0);
            WrapDynaBeanTestCase.fail((String)"Invalid get should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException t) {
            // empty catch block
        }
        try {
            this.bean.set("invalidProperty", 0, (Object)"XYZ");
            WrapDynaBeanTestCase.fail((String)"Invalid set should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException t) {
            // empty catch block
        }
        String testValue = "Original Value";
        String testProperty = "stringIndexed";
        TestBean instance = (TestBean)((WrapDynaBean)this.bean).getInstance();
        instance.setStringIndexed(0, testValue);
        WrapDynaBeanTestCase.assertEquals((String)"Check String property", (String)testValue, (String)instance.getStringIndexed(0));
        try {
            testValue = "Some new value";
            this.bean.set(testProperty, 0, (Object)testValue);
            WrapDynaBeanTestCase.assertEquals((String)"Test Set", (String)testValue, (String)instance.getStringIndexed(0));
            WrapDynaBeanTestCase.assertEquals((String)"Test Get", (Object)testValue, (Object)this.bean.get(testProperty, 0));
        }
        catch (IllegalArgumentException t) {
            WrapDynaBeanTestCase.fail((String)("Get threw exception: " + t));
        }
    }

    public void testMappedContains() {
        try {
            WrapDynaBeanTestCase.assertTrue((String)"Can see first key", (boolean)this.bean.contains("mappedProperty", "First Key"));
            WrapDynaBeanTestCase.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException t) {
        }
        catch (Throwable t) {
            WrapDynaBeanTestCase.fail((String)("Exception: " + t));
        }
        try {
            WrapDynaBeanTestCase.assertTrue((String)"Can not see unknown key", (!this.bean.contains("mappedProperty", "Unknown Key") ? 1 : 0) != 0);
            WrapDynaBeanTestCase.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException t) {
        }
        catch (Throwable t) {
            WrapDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testMappedRemove() {
        try {
            WrapDynaBeanTestCase.assertTrue((String)"Can see first key", (boolean)this.bean.contains("mappedProperty", "First Key"));
            this.bean.remove("mappedProperty", "First Key");
            WrapDynaBeanTestCase.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException t) {
        }
        catch (Throwable t) {
            WrapDynaBeanTestCase.fail((String)("Exception: " + t));
        }
        try {
            WrapDynaBeanTestCase.assertTrue((String)"Can not see unknown key", (!this.bean.contains("mappedProperty", "Unknown Key") ? 1 : 0) != 0);
            this.bean.remove("mappedProperty", "Unknown Key");
            WrapDynaBeanTestCase.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException t) {
        }
        catch (Throwable t) {
            WrapDynaBeanTestCase.fail((String)("Exception: " + t));
        }
    }

    public void testGetInstance() {
        AlphaBean alphaBean = new AlphaBean("Now On Air... John Peel");
        WrapDynaBean dynaBean = new WrapDynaBean((Object)alphaBean);
        Object wrappedInstance = dynaBean.getInstance();
        WrapDynaBeanTestCase.assertTrue((String)"Object type is AlphaBean", (boolean)(wrappedInstance instanceof AlphaBean));
        AlphaBean wrappedAlphaBean = (AlphaBean)wrappedInstance;
        WrapDynaBeanTestCase.assertTrue((String)"Same Object", (wrappedAlphaBean == alphaBean ? 1 : 0) != 0);
    }

    public void testNewInstance() throws Exception {
        WrapDynaClass dynaClass = WrapDynaClass.createDynaClass(AlphaBean.class);
        DynaBean createdInstance = dynaClass.newInstance();
        WrapDynaBeanTestCase.assertTrue((String)"Object type is WrapDynaBean", (boolean)(createdInstance instanceof WrapDynaBean));
        WrapDynaBean dynaBean = (WrapDynaBean)createdInstance;
        WrapDynaBeanTestCase.assertTrue((String)"Object type is AlphaBean", (boolean)(dynaBean.getInstance() instanceof AlphaBean));
    }

    public void testSerialization() {
        WrapDynaBean origBean = new WrapDynaBean((Object)new TestBean());
        Integer newValue = new Integer(789);
        WrapDynaBeanTestCase.assertEquals((String)"origBean default", (Object)new Integer(123), (Object)origBean.get("intProperty"));
        origBean.set("intProperty", (Object)newValue);
        WrapDynaBeanTestCase.assertEquals((String)"origBean new value", (Object)newValue, (Object)origBean.get("intProperty"));
        WrapDynaBean bean = (WrapDynaBean)this.serializeDeserialize(origBean, "First Test");
        WrapDynaBeanTestCase.assertEquals((String)"bean value", (Object)newValue, (Object)bean.get("intProperty"));
    }

    private Object serializeDeserialize(Object target, String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(target);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            WrapDynaBeanTestCase.fail((String)(text + ": Exception during serialization: " + e));
        }
        Object result = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
            bais.close();
        }
        catch (Exception e) {
            WrapDynaBeanTestCase.fail((String)(text + ": Exception during deserialization: " + e));
        }
        return result;
    }

    public void testInitWithDynaClass() {
        WrapDynaClass clazz = WrapDynaClass.createDynaClass(TestBean.class);
        this.bean = new WrapDynaBean((Object)new TestBean(), clazz);
        WrapDynaBeanTestCase.assertSame((String)"Wrong DynaClass", (Object)clazz, (Object)this.bean.getDynaClass());
        this.checkSimplePropertyAccess();
    }

    public void testGetWrapDynaClassFromCache() {
        WrapDynaClass clazz = WrapDynaClass.createDynaClass(TestBean.class);
        WrapDynaBeanTestCase.assertSame((String)"Instance not cached", (Object)clazz, (Object)WrapDynaClass.createDynaClass(TestBean.class));
    }

    public void testGetWrapDynaClassFromCacheWithPropUtils() {
        WrapDynaClass clazz = WrapDynaClass.createDynaClass(TestBean.class);
        PropertyUtilsBean pu = new PropertyUtilsBean();
        WrapDynaClass clazz2 = WrapDynaClass.createDynaClass(TestBean.class, (PropertyUtilsBean)pu);
        WrapDynaBeanTestCase.assertNotSame((String)"Got same instance from cache", (Object)clazz, (Object)clazz2);
    }

    public void testIntrospectionWithCustomPropUtils() {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        pu.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        WrapDynaClass dynaClass = WrapDynaClass.createDynaClass(FluentIntrospectionTestBean.class, (PropertyUtilsBean)pu);
        FluentIntrospectionTestBean obj = new FluentIntrospectionTestBean();
        this.bean = new WrapDynaBean((Object)obj, dynaClass);
        this.bean.set("fluentProperty", (Object)"testvalue");
        WrapDynaBeanTestCase.assertEquals((String)"Property not set", (String)"testvalue", (String)obj.getStringProperty());
    }
}

