/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigDecimal;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public BigDecimalConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new BigDecimal("-12");
        this.numbers[1] = new BigDecimal("13");
        this.numbers[2] = new BigDecimal("-22");
        this.numbers[3] = new BigDecimal("23");
    }

    public static TestSuite suite() {
        return new TestSuite(BigDecimalConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new BigDecimalConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new BigDecimalConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return BigDecimal.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{"-17.2", "-1.1", "0.0", "1.1", "17.2", new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float("11.1"), new Double("12.2")};
        BigDecimal[] expected = new BigDecimal[]{new BigDecimal("-17.2"), new BigDecimal("-1.1"), new BigDecimal("0.0"), new BigDecimal("1.1"), new BigDecimal("17.2"), new BigDecimal("7"), new BigDecimal("8"), new BigDecimal("9"), new BigDecimal("10"), new BigDecimal("11.1"), new BigDecimal("12.2")};
        for (int i = 0; i < expected.length; ++i) {
            BigDecimalConverterTestCase.assertEquals((String)(message[i] + " to BigDecimal"), (Object)expected[i], (Object)this.converter.convert(BigDecimal.class, input[i]));
            BigDecimalConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

