/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.io.File;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.FileConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConverterTestCase
extends TestCase {
    private Converter converter = null;

    public FileConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    public static TestSuite suite() {
        return new TestSuite(FileConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    protected Converter makeConverter() {
        return new FileConverter();
    }

    protected Class<?> getExpectedType() {
        return File.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String"};
        Object[] input = new Object[]{"/tmp", "/tmp/foo.txt", "/tmp/does/not/exist.foo"};
        File[] expected = new File[]{new File("/tmp"), new File("/tmp/foo.txt"), new File("/tmp/does/not/exist.foo")};
        for (int i = 0; i < expected.length; ++i) {
            FileConverterTestCase.assertEquals((String)(message[i] + " to File"), (Object)expected[i], (Object)this.converter.convert(File.class, input[i]));
            FileConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }

    public void testUnsupportedTargetType() {
        try {
            this.converter.convert(Integer.class, (Object)"/tmp");
            FileConverterTestCase.fail((String)"Could convert to unsupported type!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

