/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public IntegerConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new Integer("-12");
        this.numbers[1] = new Integer("13");
        this.numbers[2] = new Integer("-22");
        this.numbers[3] = new Integer("23");
    }

    public static TestSuite suite() {
        return new TestSuite(IntegerConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new IntegerConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new IntegerConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Integer.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Integer.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Integer.MAX_VALUE), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        Integer[] expected = new Integer[]{new Integer(Integer.MIN_VALUE), new Integer(-17), new Integer(-1), new Integer(0), new Integer(1), new Integer(17), new Integer(Integer.MAX_VALUE), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12)};
        for (int i = 0; i < expected.length; ++i) {
            IntegerConverterTestCase.assertEquals((String)(message[i] + " to Integer"), (Object)expected[i], (Object)this.converter.convert(Integer.class, input[i]));
            IntegerConverterTestCase.assertEquals((String)(message[i] + " to int"), (Object)expected[i], (Object)this.converter.convert(Integer.TYPE, input[i]));
            IntegerConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Integer> clazz = Integer.class;
        Long min = new Long(Integer.MIN_VALUE);
        Long max = new Long(Integer.MAX_VALUE);
        Long minMinusOne = new Long(min - 1L);
        Long maxPlusOne = new Long(max + 1L);
        IntegerConverterTestCase.assertEquals((String)"Minimum", (Object)new Integer(Integer.MIN_VALUE), (Object)converter.convert(clazz, (Object)min));
        IntegerConverterTestCase.assertEquals((String)"Maximum", (Object)new Integer(Integer.MAX_VALUE), (Object)converter.convert(clazz, (Object)max));
        try {
            IntegerConverterTestCase.assertEquals((String)"Minimum - 1", null, (Object)converter.convert(clazz, (Object)minMinusOne));
            IntegerConverterTestCase.fail((String)"Less than minimum, expected ConversionException");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            IntegerConverterTestCase.assertEquals((String)"Maximum + 1", null, (Object)converter.convert(clazz, (Object)maxPlusOne));
            IntegerConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testInvalidDefaultObject() {
        NumberConverter converter = this.makeConverter();
        try {
            converter.setDefaultValue((Object)"notANumber");
            IntegerConverterTestCase.fail((String)"Invalid default value not detected!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

