/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MappedPropertyChildBean;
import org.apache.commons.beanutils.MappedPropertyChildInterface;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MappedPropertyTestBean;
import org.apache.commons.beanutils.MappedPropertyTestInterface;

public class MappedPropertyTestCase
extends TestCase {
    public MappedPropertyTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MappedPropertyTestCase.suite());
    }

    public void setUp() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(MappedPropertyTestCase.class);
    }

    public void tearDown() {
    }

    public void testFound() {
        String property = "mapproperty";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testBooleanMapped() {
        String property = "mappedBoolean";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testNotFound() {
        String property = "xxxxxxx";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.fail((String)("Property '" + property + "' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMappedGetterOnly() {
        String property = "mappedGetterOnly";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNull((String)"Setter is found", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testMappedSetterOnly() {
        String property = "mappedSetterOnly";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testInvalidSetter() {
        String property = "invalidSetter";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNull((String)"Setter is found", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testInvalidGetter() {
        String property = "invalidGetter";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testDifferentTypes() {
        String property = "differentTypes";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNull((String)"Setter is found", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testMapGetter() {
        MappedPropertyTestBean bean = new MappedPropertyTestBean();
        try {
            String testValue = "test value";
            String testKey = "testKey";
            BeanUtils.setProperty((Object)bean, (String)("myMap(" + testKey + ")"), (Object)"test value");
            MappedPropertyTestCase.assertEquals((String)"Map getter", (Object)testValue, (Object)bean.getMyMap().get(testKey));
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Test set mapped property failed: " + ex));
        }
    }

    public void testAnyArgsProperty() {
        String property = "anyMapped";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testPrimitiveArgsProperty() {
        String property = "mappedPrimitive";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testProtected() {
        String property = "protectedProperty";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.fail((String)("Property '" + property + "' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPublicParentMethod() {
        String property = "mapproperty";
        Class<MappedPropertyChildBean> clazz = MappedPropertyChildBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testProtectedParentMethod() {
        String property = "protectedMapped";
        Class<MappedPropertyChildBean> clazz = MappedPropertyChildBean.class;
        try {
            new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.fail((String)("Property '" + property + "' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInterfaceMapped() {
        String property = "mapproperty";
        Class<MappedPropertyTestInterface> clazz = MappedPropertyTestInterface.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testInterfaceNotFound() {
        String property = "XXXXXX";
        Class<MappedPropertyTestInterface> clazz = MappedPropertyTestInterface.class;
        try {
            new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.fail((String)("Property '" + property + "' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testChildInterfaceMapped() {
        String property = "mapproperty";
        Class<MappedPropertyChildInterface> clazz = MappedPropertyChildInterface.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor(property, clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property '" + property + "' Not Found in " + clazz.getName() + ": " + ex));
        }
    }
}

