/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverterTestBase;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimestampConverterTestCase
extends DateConverterTestBase {
    public SqlTimestampConverterTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(SqlTimestampConverterTestCase.class);
    }

    @Override
    public void testLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String pattern = "M/d/yy h:mm a";
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        String testString = "3/21/06 3:06 pm";
        Object expected = this.toType(testString, pattern, null);
        this.validConversion((Converter)converter, expected, testString);
        this.invalidConversion((Converter)converter, null);
        this.invalidConversion((Converter)converter, "");
        this.invalidConversion((Converter)converter, "13:05 pm");
        this.invalidConversion((Converter)converter, "11:05 p");
        this.invalidConversion((Converter)converter, "11.05 pm");
        this.invalidConversion((Converter)converter, new Integer(2));
        Locale.setDefault(defaultLocale);
    }

    @Override
    public void testDefaultStringToTypeConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "2006-10-23 15:36:01.0";
        Object expected = this.toType(testString, "yyyy-MM-dd HH:mm:ss.S", null);
        this.validConversion((Converter)converter, expected, testString);
        this.invalidConversion((Converter)converter, "2006/09/21 15:36:01.0");
        this.invalidConversion((Converter)converter, "2006-10-22");
        this.invalidConversion((Converter)converter, "15:36:01");
    }

    @Override
    protected DateTimeConverter makeConverter() {
        return new SqlTimestampConverter();
    }

    @Override
    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new SqlTimestampConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Timestamp.class;
    }

    @Override
    protected Object toType(Calendar value) {
        return new Timestamp(this.getTimeInMillis(value));
    }
}

