/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.LocaleConvertUtils;
import org.apache.commons.beanutils.locale.converters.BaseLocaleConverterTestCase;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;

public class FloatLocaleConverterTestCase
extends BaseLocaleConverterTestCase {
    public FloatLocaleConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.defaultValue = new Float("9.99");
        this.expectedValue = new Float(this.expectedDecimalValue);
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testConstructorMain() {
        this.converter = new FloatLocaleConverter(this.defaultValue, this.localizedLocale, this.localizedDecimalPattern, true);
        this.convertValueNoPattern(this.converter, "(A)", this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedDecimalValue, this.localizedDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultDecimalValue, new Float("1.234"));
        this.convertValueWithPattern(this.converter, "(B)", this.localizedDecimalValue, this.defaultDecimalPattern, this.defaultValue);
        this.converter = new FloatLocaleConverter(this.defaultValue, this.localizedLocale, this.defaultDecimalPattern, false);
        this.convertValueNoPattern(this.converter, "(C)", this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    public void testConstructor_2() {
        this.converter = new FloatLocaleConverter();
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_3() {
        this.converter = new FloatLocaleConverter(true);
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_4() {
        this.converter = new FloatLocaleConverter(this.localizedLocale);
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_5() {
        this.converter = new FloatLocaleConverter(this.localizedLocale, true);
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.localizedDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_6() {
        this.converter = new FloatLocaleConverter(this.localizedLocale, this.defaultDecimalPattern);
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_7() {
        this.converter = new FloatLocaleConverter(this.localizedLocale, this.localizedDecimalPattern, true);
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.localizedDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_8() {
        this.converter = new FloatLocaleConverter(this.defaultValue);
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testConstructor_9() {
        this.converter = new FloatLocaleConverter(this.defaultValue, true);
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testFloatLimits() {
        this.converter = new FloatLocaleConverter(this.defaultLocale, this.defaultDecimalPattern);
        DecimalFormat fmt = new DecimalFormat("#.#############################################################");
        FloatLocaleConverterTestCase.assertEquals((Object)new Float(-0.12), (Object)this.converter.convert((Object)"-0.12"));
        FloatLocaleConverterTestCase.assertEquals((String)"Positive Float.MAX_VALUE", (Object)new Float(Float.MAX_VALUE), (Object)this.converter.convert((Object)fmt.format(3.4028234663852886E38)));
        FloatLocaleConverterTestCase.assertEquals((String)"Positive Float.MIN_VALUE", (Object)new Float(Float.MIN_VALUE), (Object)this.converter.convert((Object)fmt.format(1.4E-45f)));
        FloatLocaleConverterTestCase.assertEquals((String)"Negative Float.MAX_VALUE", (Object)new Float(-3.4028235E38f), (Object)this.converter.convert((Object)fmt.format(-3.4028234663852886E38)));
        FloatLocaleConverterTestCase.assertEquals((String)"Negative Float.MIN_VALUE", (Object)new Float(-1.4E-45f), (Object)this.converter.convert((Object)fmt.format(-1.4E-45f)));
        try {
            this.converter.convert((Object)fmt.format(3.4028234663852886E39));
            FloatLocaleConverterTestCase.fail((String)"Positive Too Large should throw ConversionException");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            this.converter.convert((Object)fmt.format(-3.4028234663852886E39));
            FloatLocaleConverterTestCase.fail((String)"Negative Too Large should throw ConversionException");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            this.converter.convert((Object)fmt.format(1.4012984643248171E-46));
            FloatLocaleConverterTestCase.fail((String)"Positive Too Small should throw ConversionException");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        try {
            this.converter.convert((Object)fmt.format(-1.4012984643248171E-46));
            FloatLocaleConverterTestCase.fail((String)"Negative Too Small should throw ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testParseZero() {
        try {
            Object result = LocaleConvertUtils.convert((String)"0", Float.class, (Locale)Locale.US, null);
            FloatLocaleConverterTestCase.assertEquals((Object)new Float(0.0f), (Object)result);
        }
        catch (ConversionException e) {
            FloatLocaleConverterTestCase.fail((String)("Zero threw ConversionException: " + (Object)((Object)e)));
        }
    }
}

