/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.TestBean;

public class ConstructorUtilsTestCase
extends TestCase {
    public ConstructorUtilsTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(ConstructorUtilsTestCase.class);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInvokeConstructor() throws Exception {
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object)"TEST");
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
        obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object)new Float(17.3f));
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((float)17.3f, (float)((TestBean)obj).getFloatProperty(), (float)0.0f);
    }

    public void testInvokeConstructorNull() throws Exception {
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, null);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
    }

    public void testInvokeConstructorWithArgArray() throws Exception {
        Object[] args = new Object[]{new Float(17.3f), "TEST"};
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object[])args);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((float)17.3f, (float)((TestBean)obj).getFloatProperty(), (float)0.0f);
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
    }

    public void testInvokeConstructorWithTypeArray() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, "TEST"};
        Class[] types = new Class[]{Boolean.TYPE, String.class};
        Object obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object[])args, (Class[])types);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((boolean)true, (boolean)((TestBean)obj).getBooleanProperty());
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
        args = new Object[]{Boolean.TRUE, "TEST"};
        types = new Class[]{Boolean.class, String.class};
        obj = ConstructorUtils.invokeConstructor(TestBean.class, (Object[])args, (Class[])types);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((boolean)true, (boolean)((TestBean)obj).isBooleanSecond());
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
    }

    public void testInvokeExactConstructor() throws Exception {
        Object obj22 = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object)"TEST");
        ConstructorUtilsTestCase.assertNotNull((Object)obj22);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj22 instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj22).getStringProperty());
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object)new Float(17.3f));
            ConstructorUtilsTestCase.fail((String)"Expected NoSuchMethodException");
        }
        catch (NoSuchMethodException obj22) {
            // empty catch block
        }
        obj22 = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object)Boolean.TRUE);
        ConstructorUtilsTestCase.assertNotNull((Object)obj22);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj22 instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((boolean)true, (boolean)((TestBean)obj22).isBooleanSecond());
    }

    public void testInvokeExactConstructorWithNull() throws Exception {
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, null);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
    }

    public void testInvokeExactConstructorWithArgArray() throws Exception {
        Object[] args = new Object[]{new Float(17.3f), "TEST"};
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args);
            ConstructorUtilsTestCase.fail((String)"Expected NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        args = new Object[]{Boolean.TRUE, "TEST"};
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((boolean)true, (boolean)((TestBean)obj).isBooleanSecond());
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
    }

    public void testInvokeExactConstructorWithTypeArray() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, "TEST"};
        Class[] types = new Class[]{Boolean.TYPE, String.class};
        Object obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((boolean)true, (boolean)((TestBean)obj).getBooleanProperty());
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
        args = new Object[]{Boolean.TRUE, "TEST"};
        types = new Class[]{Boolean.class, String.class};
        obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((boolean)true, (boolean)((TestBean)obj).isBooleanSecond());
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
        args = new Object[]{new Float(17.3f), "TEST"};
        types = new Class[]{Float.TYPE, String.class};
        obj = ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
        ConstructorUtilsTestCase.assertNotNull((Object)obj);
        ConstructorUtilsTestCase.assertTrue((boolean)(obj instanceof TestBean));
        ConstructorUtilsTestCase.assertEquals((float)17.3f, (float)((TestBean)obj).getFloatProperty(), (float)0.0f);
        ConstructorUtilsTestCase.assertEquals((String)"TEST", (String)((TestBean)obj).getStringProperty());
        args = new Object[]{new Float(17.3f), "TEST"};
        types = new Class[]{Float.class, String.class};
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])args, (Class[])types);
            ConstructorUtilsTestCase.fail((String)"Expected NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGetAccessibleConstructor() throws Exception {
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, String.class);
        ConstructorUtilsTestCase.assertNotNull((Object)ctor);
        ConstructorUtilsTestCase.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, Integer.class);
        ConstructorUtilsTestCase.assertNotNull((Object)ctor);
        ConstructorUtilsTestCase.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, Integer.TYPE);
        ConstructorUtilsTestCase.assertNull((Object)ctor);
    }

    public void testGetAccessibleConstructorWithTypeArray() throws Exception {
        Class[] types = new Class[]{Boolean.TYPE, String.class};
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, (Class[])types);
        ConstructorUtilsTestCase.assertNotNull((Object)ctor);
        ConstructorUtilsTestCase.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        types = new Class[]{Boolean.TYPE, Boolean.TYPE, String.class};
        ctor = ConstructorUtils.getAccessibleConstructor(TestBean.class, (Class[])types);
        ConstructorUtilsTestCase.assertNull((Object)ctor);
    }

    public void testGetAccessibleConstructorWithConstructorArg() throws Exception {
        Class[] types = new Class[]{Integer.class};
        Constructor c1 = TestBean.class.getConstructor(types);
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(c1);
        ConstructorUtilsTestCase.assertNotNull((Object)ctor);
        ConstructorUtilsTestCase.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        types = new Class[]{Integer.class};
        c1 = TestBean.class.getDeclaredConstructor(types);
        ctor = ConstructorUtils.getAccessibleConstructor(c1);
        ConstructorUtilsTestCase.assertNotNull((Object)ctor);
        ConstructorUtilsTestCase.assertTrue((boolean)Modifier.isPublic(ctor.getModifiers()));
        types = new Class[]{Integer.TYPE};
        c1 = TestBean.class.getDeclaredConstructor(types);
        ctor = ConstructorUtils.getAccessibleConstructor(c1);
        ConstructorUtilsTestCase.assertNull((Object)ctor);
    }
}

