/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.memoryleaktests;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.WrapDynaClass;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtils;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class MemoryLeakTestCase {
    @Test
    public void testPropertyUtilsBean_descriptorsCache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        Assert.assertEquals((Object)"initialValue", (Object)PropertyUtils.getProperty(bean, (String)"name"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("PropertyUtilsBean descriptorsCache", "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo");
        }
        Assert.assertNull((String)"PropertyUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testPropertyUtilsBean_mappedDescriptorsCache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        Assert.assertEquals((Object)"Second Value", (Object)PropertyUtils.getProperty(bean, (String)"mappedProperty(Second Key)"));
        PropertyUtils.setProperty(bean, (String)"mappedProperty(Second Key)", (Object)"New Second Value");
        Assert.assertEquals((Object)"New Second Value", (Object)PropertyUtils.getProperty(bean, (String)"mappedProperty(Second Key)"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("PropertyUtilsBean mappedDescriptorsCache", "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo");
        }
        Assert.assertNull((String)"PropertyUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testMappedPropertyDescriptor_MappedMethodReference1() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo");
        Object bean = beanClass.newInstance();
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotNull((String)"Bean is null", bean);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MappedPropertyDescriptor descriptor = new MappedPropertyDescriptor("mappedProperty", beanClass);
        Assert.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        Assert.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        Assert.assertEquals((String)"1-Read Method name", (Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName());
        Assert.assertEquals((String)"1-Read Write name", (Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName());
        this.forceGarbageCollection();
        Assert.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        Assert.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        Assert.assertEquals((String)"1-Read Method name", (Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName());
        Assert.assertEquals((String)"1-Read Write name", (Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testMappedPropertyDescriptor_MappedMethodReference2() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.SomeMappedPojo");
        Object bean = beanClass.newInstance();
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotNull((String)"Bean is null", bean);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MappedPropertyDescriptor descriptor = new MappedPropertyDescriptor("mappedProperty", beanClass);
        Assert.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        Assert.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        Assert.assertEquals((String)"1-Read Method name", (Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName());
        Assert.assertEquals((String)"1-Read Write name", (Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName());
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        Assert.assertNotNull((String)"1-Read Method null", (Object)descriptor.getMappedReadMethod());
        Assert.assertNotNull((String)"1-Write Method null", (Object)descriptor.getMappedWriteMethod());
        Assert.assertEquals((String)"1-Read Method name", (Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName());
        Assert.assertEquals((String)"1-Read Write name", (Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testMethodUtils_cache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        Assert.assertEquals((Object)"initialValue", (Object)MethodUtils.invokeExactMethod(bean, (String)"getName", (Object[])new Object[0]));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("MethodUtils cache", "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo");
        }
        Assert.assertNull((String)"MethodUtils is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testWrapDynaClass_dynaClasses_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo");
        Object bean = beanClass.newInstance();
        WrapDynaBean wrapDynaBean = new WrapDynaBean(bean);
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        Assert.assertEquals((Object)"initialValue", (Object)wrapDynaBean.get("name"));
        loader = null;
        beanClass = null;
        bean = null;
        wrapDynaBean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("WrapDynaClass dynaClasses", "org.apache.commons.beanutils.memoryleaktests.pojotests.SomePojo");
        }
        Assert.assertNull((String)"WrapDynaClass is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testConvertUtilsBean_converters_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        ConvertUtils.register((Converter)new IntegerConverter(), beanClass);
        Assert.assertEquals((Object)"12345", (Object)ConvertUtils.convert(bean, String.class));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("ConvertUtilsBean converters", "org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger");
        }
        Assert.assertNull((String)"ConvertUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testLocaleConvertUtilsBean_converters_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger";
        URLClassLoader loader = MemoryLeakTestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assert.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Assert.assertNotNull((String)"BeanClass is null", beanClass);
        Assert.assertNotSame((String)"ClassLoaders should be different..", (Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Assert.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        LocaleConvertUtils.register((LocaleConverter)new IntegerLocaleConverter(Locale.US, false), beanClass, (Locale)Locale.US);
        Assert.assertEquals((Object)new Integer(12345), (Object)LocaleConvertUtils.convert((String)bean.toString(), Integer.class, (Locale)Locale.US, (String)"#,###"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("LocaleConvertUtilsBean converters", "org.apache.commons.beanutils.memoryleaktests.pojotests.CustomInteger");
        }
        Assert.assertNull((String)"LocaleConvertUtilsBean is holding a reference to the classLoader", someRef.get());
        this.clearAllBeanUtilsCaches();
    }

    private void clearAllBeanUtilsCaches() {
        BeanUtilsBean.getInstance().getPropertyUtils().clearDescriptors();
        LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getPropertyUtils().clearDescriptors();
        MethodUtils.clearCache();
        WrapDynaClass.clear();
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean());
        LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)new LocaleBeanUtilsBean());
    }

    private void forceGarbageCollection() throws Exception {
        SoftReference<Object> ref = new SoftReference<Object>(new Object());
        int count = 0;
        while (ref.get() != null && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (ref.get() != null) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
                System.out.println("Count(1) " + count + " : " + this.getMemoryStats());
            }
            catch (OutOfMemoryError i) {
                // empty catch block
            }
            System.gc();
            list.clear();
            list = null;
            System.gc();
            System.out.println("After GC2: " + this.getMemoryStats() + " Count " + count);
            Thread.sleep(1000L);
        }
        boolean isNotNull = ref.get() != null;
        System.out.println("Count " + count + " " + isNotNull);
        String message = "Your JVM is not releasing SoftReference, try running the testcase with less memory (-Xmx)";
        Assume.assumeFalse((String)message, (boolean)isNotNull);
    }

    private static URLClassLoader newClassLoader() throws MalformedURLException {
        String dataFilePath = MemoryLeakTestCase.class.getResource("pojotests").getFile();
        String location = "file://" + dataFilePath.substring(0, dataFilePath.length() - "org.apache.commons.beanutils.memoryleaktests.pojotests".length());
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < location.length(); ++i) {
            if (location.charAt(i) == '\\') {
                newString.append("/");
                continue;
            }
            newString.append(location.charAt(i));
        }
        String classLocation = newString.toString();
        URLClassLoader theLoader = URLClassLoader.newInstance(new URL[]{new URL(classLocation)}, null);
        return theLoader;
    }

    private void profilerLeakReport(String test, String className) {
    }

    private String getMemoryStats() {
        DecimalFormat fmt = new DecimalFormat("#,##0");
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory() / 1024L;
        long total = runtime.totalMemory() / 1024L;
        long used = total - free;
        return "MEMORY - Total: " + fmt.format(total) + "k " + "Used: " + fmt.format(used) + "k " + "Free: " + fmt.format(free) + "k";
    }
}

