/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import org.apache.commons.beanutils.locale.converters.BaseLocaleConverterTestCase;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;

public class IntegerLocaleConverterTestCase
extends BaseLocaleConverterTestCase {
    public IntegerLocaleConverterTestCase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.defaultValue = new Integer("999");
        this.expectedValue = new Integer(this.expectedIntegerValue);
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testConstructorMain() {
        this.converter = new IntegerLocaleConverter(this.defaultValue, this.localizedLocale, this.localizedIntegerPattern, true);
        this.convertValueNoPattern(this.converter, "(A)", this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultIntegerValue, new Integer("1"));
        this.convertValueWithPattern(this.converter, "(B)", this.localizedIntegerValue, this.defaultIntegerPattern, new Integer("1"));
        this.converter = new IntegerLocaleConverter(this.defaultValue, this.localizedLocale, this.defaultIntegerPattern, false);
        this.convertValueNoPattern(this.converter, "(C)", this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    public void testConstructor_2() {
        this.converter = new IntegerLocaleConverter();
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_3() {
        this.converter = new IntegerLocaleConverter(true);
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_4() {
        this.converter = new IntegerLocaleConverter(this.localizedLocale);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_5() {
        this.converter = new IntegerLocaleConverter(this.localizedLocale, true);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_6() {
        this.converter = new IntegerLocaleConverter(this.localizedLocale, this.defaultIntegerPattern);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_7() {
        this.converter = new IntegerLocaleConverter(this.localizedLocale, this.localizedIntegerPattern, true);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_8() {
        this.converter = new IntegerLocaleConverter(this.defaultValue);
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testConstructor_9() {
        this.converter = new IntegerLocaleConverter(this.defaultValue, true);
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testNumber() {
        this.converter = new IntegerLocaleConverter(this.localizedLocale);
        Integer value = new Integer(1234);
        IntegerLocaleConverterTestCase.assertEquals((String)"Convert Integer", (Object)value, (Object)this.converter.convert((Object)value));
        IntegerLocaleConverterTestCase.assertEquals((String)"Convert Long", (Object)value, (Object)this.converter.convert((Object)new Long(value.intValue())));
    }

    public void testToPrimitiveType() {
        this.converter = new IntegerLocaleConverter();
        Integer value = 20131028;
        Class<Integer> target = Integer.TYPE;
        int result = (Integer)this.converter.convert(target, (Object)value.toString());
        IntegerLocaleConverterTestCase.assertEquals((String)"Wrong result", (int)value, (int)result);
    }
}

