/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.apache.commons.beanutils.BeanUtilsTestCase;
import org.apache.commons.beanutils.ConvertUtils;

public class BeanUtils2TestCase
extends BeanUtilsTestCase {
    public BeanUtils2TestCase(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        ConvertUtils.deregister();
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean2());
        this.setUpShared();
    }

    public static Test suite() {
        return new TestSuite(BeanUtils2TestCase.class);
    }

    @Override
    public void tearDown() {
        this.bean = null;
    }

    @Override
    public void testCopyPropertyConvertToString() {
        try {
            BeanUtils.copyProperty((Object)this.bean, (String)"stringProperty", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date --> String", (String)this.testStringDate, (String)this.bean.getStringProperty());
    }

    @Override
    public void testCopyPropertyConvertToStringArray() {
        try {
            this.bean.setStringArray(null);
            BeanUtils.copyProperty((Object)this.bean, (String)"stringArray", (Object)new Date[]{this.testUtilDate});
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)this.bean.getStringArray().length);
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testStringDate, (String)this.bean.getStringArray()[0]);
    }

    @Override
    public void testCopyPropertyConvertToStringIndexed() {
        try {
            this.bean.setStringArray(new String[1]);
            BeanUtils.copyProperty((Object)this.bean, (String)"stringArray[0]", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)this.bean.getStringArray().length);
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testStringDate, (String)this.bean.getStringArray()[0]);
    }

    @Override
    public void testGetArrayPropertyDate() {
        String[] value = null;
        try {
            this.bean.setDateArrayProperty(new Date[]{this.testUtilDate});
            value = BeanUtils.getArrayProperty((Object)this.bean, (String)"dateArrayProperty");
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)value.length);
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testStringDate, (String)value[0]);
    }

    @Override
    public void testGetIndexedPropertyDate() {
        String value = null;
        try {
            this.bean.setDateArrayProperty(new Date[]{this.testUtilDate});
            value = BeanUtils.getIndexedProperty((Object)this.bean, (String)"dateArrayProperty[0]");
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[0] --> String", (String)this.testStringDate, (String)value);
    }

    @Override
    public void testGetSimplePropertyDate() {
        String value = null;
        try {
            this.bean.setDateProperty(this.testUtilDate);
            value = BeanUtils.getSimpleProperty((Object)this.bean, (String)"dateProperty");
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date --> String", (String)this.testStringDate, (String)value);
    }

    @Override
    public void testSetPropertyConvertToString() {
        try {
            BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date --> String", (String)this.testStringDate, (String)this.bean.getStringProperty());
    }

    @Override
    public void testSetPropertyConvertToStringArray() {
        try {
            this.bean.setStringArray(null);
            BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)new Date[]{this.testUtilDate});
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] length", (int)1, (int)this.bean.getStringArray().length);
        BeanUtils2TestCase.assertEquals((String)"java.util.Date[] --> String[] value ", (String)this.testStringDate, (String)this.bean.getStringArray()[0]);
    }

    @Override
    public void testSetPropertyConvertToStringIndexed() {
        try {
            this.bean.setStringArray(new String[1]);
            BeanUtils.setProperty((Object)this.bean, (String)"stringArray[0]", (Object)this.testUtilDate);
        }
        catch (Throwable t) {
            BeanUtils2TestCase.fail((String)("Threw " + t));
        }
        BeanUtils2TestCase.assertEquals((String)"java.util.Date --> String[]", (String)this.testStringDate, (String)this.bean.getStringArray()[0]);
    }
}

