/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class ByteConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public ByteConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new Byte("-12");
        this.numbers[1] = new Byte("13");
        this.numbers[2] = new Byte("-22");
        this.numbers[3] = new Byte("23");
    }

    public static TestSuite suite() {
        return new TestSuite(ByteConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new ByteConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new ByteConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Byte.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(-128), "-17", "-1", "0", "1", "17", String.valueOf(127), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        Byte[] expected = new Byte[]{new Byte(-128), new Byte(-17), new Byte(-1), new Byte(0), new Byte(1), new Byte(17), new Byte(127), new Byte(7), new Byte(8), new Byte(9), new Byte(10), new Byte(11), new Byte(12)};
        for (int i = 0; i < expected.length; ++i) {
            ByteConverterTestCase.assertEquals((String)(message[i] + " to Byte"), (Object)expected[i], (Object)this.converter.convert(Byte.class, input[i]));
            ByteConverterTestCase.assertEquals((String)(message[i] + " to byte"), (Object)expected[i], (Object)this.converter.convert(Byte.TYPE, input[i]));
            ByteConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Byte> clazz = Byte.class;
        Long min = new Long(-128L);
        Long max = new Long(127L);
        Long minMinusOne = new Long(min - 1L);
        Long maxPlusOne = new Long(max + 1L);
        ByteConverterTestCase.assertEquals((String)"Minimum", (Object)new Byte(-128), (Object)converter.convert(clazz, (Object)min));
        ByteConverterTestCase.assertEquals((String)"Maximum", (Object)new Byte(127), (Object)converter.convert(clazz, (Object)max));
        try {
            ByteConverterTestCase.assertEquals((String)"Minimum - 1", null, (Object)converter.convert(clazz, (Object)minMinusOne));
            ByteConverterTestCase.fail((String)"Less than minimum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ByteConverterTestCase.assertEquals((String)"Maximum + 1", null, (Object)converter.convert(clazz, (Object)maxPlusOne));
            ByteConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

