/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Date;
import java.util.Calendar;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverterTestBase;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;

public class SqlDateConverterTestCase
extends DateConverterTestBase {
    public SqlDateConverterTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(SqlDateConverterTestCase.class);
    }

    @Override
    public void testDefaultStringToTypeConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "2006-05-16";
        Object expected = this.toType("2006-05-16", "yyyy-MM-dd", null);
        this.validConversion((Converter)converter, expected, "2006-05-16");
        this.invalidConversion((Converter)converter, "01/01/2006");
    }

    public void testDefaultTypeToStringConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String expected = "2006-05-16";
        Object testVal = this.toType("2006-05-16", "yyyy-MM-dd", null);
        this.stringConversion((Converter)converter, "2006-05-16", testVal);
        Object result = converter.convert(String.class, (Object)new Integer(2));
        SqlDateConverterTestCase.assertEquals((String)"Default toString()", (Object)"2", (Object)result);
    }

    @Override
    protected DateTimeConverter makeConverter() {
        return new SqlDateConverter();
    }

    @Override
    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new SqlDateConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Date.class;
    }

    @Override
    protected Object toType(Calendar value) {
        return new Date(this.getTimeInMillis(value));
    }
}

