/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils2.DefaultIntrospectionContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultIntrospectionContextTest {
    private static final String PROP = "foo";
    private DefaultIntrospectionContext context;

    private static PropertyDescriptor createDescriptor(String propName) {
        try {
            return new PropertyDescriptor(propName, DefaultIntrospectionContextTest.class, null, null);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Unexpected exception: " + e);
        }
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.context = new DefaultIntrospectionContext(this.getClass());
    }

    @Test
    public void testAddPropertyDescriptor() {
        PropertyDescriptor desc = DefaultIntrospectionContextTest.createDescriptor(PROP);
        this.context.addPropertyDescriptor(desc);
        Assertions.assertTrue((boolean)this.context.hasProperty(PROP), (String)"Property not found");
        Assertions.assertSame((Object)desc, (Object)this.context.getPropertyDescriptor(PROP), (String)"Wrong descriptor");
    }

    @Test
    public void testAddPropertyDescriptorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.context.addPropertyDescriptor(null));
    }

    @Test
    public void testAddPropertyDescriptors() {
        int count = 4;
        PropertyDescriptor[] descs = new PropertyDescriptor[4];
        HashSet<PropertyDescriptor> descSet = new HashSet<PropertyDescriptor>();
        for (int i = 0; i < 4; ++i) {
            descs[i] = DefaultIntrospectionContextTest.createDescriptor(PROP + i);
            descSet.add(descs[i]);
        }
        this.context.addPropertyDescriptors(descs);
        PropertyDescriptor d = DefaultIntrospectionContextTest.createDescriptor(PROP);
        this.context.addPropertyDescriptor(d);
        descSet.add(d);
        Set names = this.context.propertyNames();
        Assertions.assertEquals((int)5, (int)names.size(), (String)"Wrong number of property names");
        Assertions.assertTrue((boolean)names.contains(PROP), (String)"Property not found: foo");
        for (int i = 0; i < 4; ++i) {
            Assertions.assertTrue((boolean)names.contains(PROP + i), (String)("Property not found: foo" + i));
        }
        PropertyDescriptor[] addedDescs = this.context.getPropertyDescriptors();
        Assertions.assertEquals((int)5, (int)addedDescs.length, (String)"Wrong number of added descriptors");
        for (PropertyDescriptor pd : addedDescs) {
            Assertions.assertTrue((boolean)descSet.remove(pd), (String)("Unexpected descriptor: " + pd));
        }
    }

    @Test
    public void testAddPropertyDescriptorsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.context.addPropertyDescriptors(null));
    }

    @Test
    public void testGetPropertyDescriptorUnknown() {
        Assertions.assertNull((Object)this.context.getPropertyDescriptor(PROP), (String)"Got a property (1)");
        this.context.addPropertyDescriptor(DefaultIntrospectionContextTest.createDescriptor(PROP));
        Assertions.assertNull((Object)this.context.getPropertyDescriptor("other"), (String)"Got a property (2)");
    }

    @Test
    public void testHasPropertyFalse() {
        Assertions.assertFalse((boolean)this.context.hasProperty(PROP), (String)"Wrong result (1)");
        this.context.addPropertyDescriptor(DefaultIntrospectionContextTest.createDescriptor(PROP));
        Assertions.assertFalse((boolean)this.context.hasProperty("other"), (String)"Wrong result (2)");
    }

    @Test
    public void testInit() {
        Assertions.assertEquals(this.getClass(), (Object)this.context.getTargetClass(), (String)"Wrong current class");
        Assertions.assertTrue((boolean)this.context.propertyNames().isEmpty(), (String)"Got property names");
    }

    @Test
    public void testPropertyNamesModify() {
        Set names = this.context.propertyNames();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> names.add(PROP));
    }

    @Test
    public void testRemovePropertyDescriptor() {
        this.context.addPropertyDescriptor(DefaultIntrospectionContextTest.createDescriptor(PROP));
        this.context.removePropertyDescriptor(PROP);
        Assertions.assertTrue((boolean)this.context.propertyNames().isEmpty(), (String)"Got property names");
        Assertions.assertEquals((int)0, (int)this.context.getPropertyDescriptors().length, (String)"Got descriptors");
    }
}

