/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodUtils {
    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method.");
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }
}

