/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
 
package org.apache.commons.betwixt;

import java.util.ArrayList;
import java.util.Iterator;

/** This is a child that has a property containing it's parent.
  *
  * @author Robert Burrell Donkin
  * @version $Revision: 1.5 $
  */
public class DoubleLinkedParentBean {

    private ArrayList children = new ArrayList();
    private String name;
    
    public DoubleLinkedParentBean () {}
    
    public DoubleLinkedParentBean(String name) {
        setName(name);
    }
    
    public String getName() {
        return name;
    }	
    
    public void setName(String name) {
        this.name = name;
    }
    
    public Iterator getChildren() {
        return children.iterator();
    }
    
    public int getSize() {
        return children.size();
    }
    
    
    public void addChild(DoubleLinkedChildBean child) {
        children.add(child);
        child.setParent(this);
    }
}

