package org.apache.commons.betwixt.scarab;

/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p><code>Module</code> is a sample bean for use by the test cases.</p>
 *
 * @author <a href="mailto:jason@zenplex.com">Jason van Zyl</a>
 * @version $Id: Module.java 155402 2005-02-26 12:52:00Z dirkv $
 */
public class Module
{
    private final static Log log = LogFactory.getLog(Module.class);

    private String name;
    
    /**
     * Constructor for the ScarabSettings object
     */
    public Module()
    { 
    }

    public void setName(String name)
    {
        log.debug("Module.setName(): " + name);
        this.name = name;
    }        

    public String getName()
    {
        return name;
    }        
}
