/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.cactus.ServletTestRequest;

public abstract class AbstractTestCase
extends TestCase {
    protected static final String TEST_METHOD_PREFIX = "test";
    protected static final String BEGIN_METHOD_PREFIX = "begin";
    protected static final String END_METHOD_PREFIX = "end";
    public String currentTestMethod = this.name();
    static /* synthetic */ Class class$org$apache$commons$cactus$ServletTestRequest;
    static /* synthetic */ Class class$java$net$HttpURLConnection;

    public AbstractTestCase(String theName) {
        super(theName);
    }

    private String getBaseMethodName() {
        if (!this.name().startsWith(TEST_METHOD_PREFIX)) {
            throw new RuntimeException("bad name [" + this.name() + "]. It should start with [" + TEST_METHOD_PREFIX + "].");
        }
        return this.name().substring(TEST_METHOD_PREFIX.length());
    }

    protected String getBeginMethodName() {
        return BEGIN_METHOD_PREFIX + this.getBaseMethodName();
    }

    protected String getEndMethodName() {
        return END_METHOD_PREFIX + this.getBaseMethodName();
    }

    protected void callBeginMethod(ServletTestRequest theRequest) throws Throwable {
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(this.getBeginMethodName())) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    Assert.fail((String)("The begin method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    Assert.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1 || !parameters[0].equals(class$org$apache$commons$cactus$ServletTestRequest == null ? AbstractTestCase.class$("org.apache.commons.cactus.ServletTestRequest") : class$org$apache$commons$cactus$ServletTestRequest)) {
                    Assert.fail((String)("The begin method [" + methods[i].getName() + "] must accept a single parameter of type [" + (class$org$apache$commons$cactus$ServletTestRequest == null ? AbstractTestCase.class$("org.apache.commons.cactus.ServletTestRequest") : class$org$apache$commons$cactus$ServletTestRequest).getName() + "]"));
                }
                try {
                    methods[i].invoke((Object)this, theRequest);
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    protected void callEndMethod(HttpURLConnection theConnection) throws Throwable {
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(this.getEndMethodName())) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    Assert.fail((String)("The end method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    Assert.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1 || !parameters[0].equals(class$java$net$HttpURLConnection == null ? AbstractTestCase.class$("java.net.HttpURLConnection") : class$java$net$HttpURLConnection)) {
                    Assert.fail((String)("The end method [" + methods[i].getName() + "] must accept a single parameter of type [" + (class$java$net$HttpURLConnection == null ? AbstractTestCase.class$("java.net.HttpURLConnection") : class$java$net$HttpURLConnection).getName() + "]"));
                }
                try {
                    methods[i].invoke((Object)this, theConnection);
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    public void runBare() throws Throwable {
        this.runTest();
    }

    protected abstract void runTest() throws Throwable;

    public void runBareServerTest() throws Throwable {
        this.setUp();
        try {
            this.runServerTest();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.tearDown();
            throw throwable;
        }
        this.tearDown();
    }

    protected void runServerTest() throws Throwable {
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(this.currentTestMethod, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Method [" + this.currentTestMethod + "()] does not exist for class [" + ((Object)((Object)this)).getClass().getName() + "]."));
        }
        if (runMethod != null && !Modifier.isPublic(runMethod.getModifiers())) {
            Assert.fail((String)("Method [" + this.currentTestMethod + "()] should be public"));
        }
        try {
            runMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

