/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.cactus.ServletURL;

public class ServletTestRequest {
    private Hashtable m_Parameters = new Hashtable();
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    private Hashtable m_Cookies = new Hashtable();
    private Hashtable m_Headers = new Hashtable();
    private ServletURL m_URL;
    private boolean m_isAutomaticSession = true;
    private String m_Method = "POST";

    public void setMethod(String theMethod) {
        if (theMethod.equalsIgnoreCase(GET_METHOD)) {
            this.m_Method = GET_METHOD;
        } else if (theMethod.equalsIgnoreCase(POST_METHOD)) {
            this.m_Method = POST_METHOD;
        }
    }

    public String getMethod() {
        return this.m_Method;
    }

    public void setAutomaticSession(boolean isAutomaticSession) {
        this.m_isAutomaticSession = isAutomaticSession;
    }

    public boolean getAutomaticSession() {
        return this.m_isAutomaticSession;
    }

    public void setURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this.m_URL = new ServletURL(theServerName, theContextPath, theServletPath, thePathInfo, theQueryString);
    }

    public ServletURL getURL() {
        return this.m_URL;
    }

    public void addParameter(String theName, String theValue) {
        if (this.m_Parameters.containsKey(theName)) {
            Vector v = (Vector)this.m_Parameters.get(theName);
            v.addElement(theValue);
        } else {
            Vector<String> v = new Vector<String>();
            v.addElement(theValue);
            this.m_Parameters.put(theName, v);
        }
    }

    public Enumeration getParameterNames() {
        return this.m_Parameters.keys();
    }

    public String getParameter(String theName) {
        String[] values = this.getParameterValues(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String theName) {
        if (this.m_Parameters.containsKey(theName)) {
            Vector v = (Vector)this.m_Parameters.get(theName);
            Object[] objs = new Object[v.size()];
            v.copyInto(objs);
            String[] result = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                result[i] = (String)objs[i];
                ++i;
            }
            return result;
        }
        return null;
    }

    public void addCookie(String theName, String theValue) {
        this.m_Cookies.put(theName, theValue);
    }

    public Enumeration getCookieNames() {
        return this.m_Cookies.keys();
    }

    public String getCookieValue(String theName) {
        return (String)this.m_Cookies.get(theName);
    }

    public void addHeader(String theName, String theValue) {
        if (this.m_Headers.containsKey(theName)) {
            Vector v = (Vector)this.m_Headers.get(theName);
            v.addElement(theValue);
        } else {
            Vector<String> v = new Vector<String>();
            v.addElement(theValue);
            this.m_Headers.put(theName, v);
        }
    }

    public Enumeration getHeaderNames() {
        return this.m_Headers.keys();
    }

    public String getHeader(String theName) {
        String[] values = this.getHeaderValues(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getHeaderValues(String theName) {
        if (this.m_Headers.containsKey(theName)) {
            Vector v = (Vector)this.m_Headers.get(theName);
            Object[] objs = new Object[v.size()];
            v.copyInto(objs);
            String[] result = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                result[i] = (String)objs[i];
                ++i;
            }
            return result;
        }
        return null;
    }
}

