/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.cactus.ServletURL;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private HttpServletRequest m_Request;
    private ServletURL m_URL;

    public HttpServletRequestWrapper(HttpServletRequest theRequest, ServletURL theURL) {
        this.m_Request = theRequest;
        this.m_URL = theURL;
    }

    public HttpServletRequest getOriginalRequest() {
        return this.m_Request;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.m_Request.isRequestedSessionIdFromURL();
    }

    public Enumeration getLocales() {
        return this.m_Request.getLocales();
    }

    public String getHeader(String theName) {
        return this.m_Request.getHeader(theName);
    }

    public String getContextPath() {
        if (this.m_URL != null) {
            return this.m_URL.getContextPath();
        }
        return this.m_Request.getContextPath();
    }

    public String getScheme() {
        return this.m_Request.getScheme();
    }

    public String getPathInfo() {
        if (this.m_URL != null) {
            return this.m_URL.getPathInfo();
        }
        return this.m_Request.getPathInfo();
    }

    public String getAuthType() {
        return this.m_Request.getAuthType();
    }

    public String getServerName() {
        if (this.m_URL != null) {
            return this.m_URL.getURL().getHost();
        }
        return this.m_Request.getServerName();
    }

    public String getRealPath(String thePath) {
        return this.m_Request.getRealPath(thePath);
    }

    public HttpSession getSession() {
        return this.m_Request.getSession();
    }

    public HttpSession getSession(boolean isCreate) {
        return this.m_Request.getSession(isCreate);
    }

    public String getRemoteHost() {
        return this.m_Request.getRemoteHost();
    }

    public Enumeration getHeaderNames() {
        return this.m_Request.getHeaderNames();
    }

    public boolean isUserInRole(String theRole) {
        return this.m_Request.isUserInRole(theRole);
    }

    public int getServerPort() {
        if (this.m_URL != null) {
            if (this.m_URL.getURL().getPort() == -1) {
                return 80;
            }
            return this.m_URL.getURL().getPort();
        }
        return this.m_Request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.m_Request.getReader();
    }

    public int getContentLength() {
        return this.m_Request.getContentLength();
    }

    public String getRequestURI() {
        if (this.m_URL != null) {
            return this.m_URL.getURL().getFile();
        }
        return this.m_Request.getRequestURI();
    }

    public String[] getParameterValues(String theName) {
        return this.m_Request.getParameterValues(theName);
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.m_Request.isRequestedSessionIdFromUrl();
    }

    public String getContentType() {
        return this.m_Request.getContentType();
    }

    public Locale getLocale() {
        return this.m_Request.getLocale();
    }

    public void removeAttribute(String theName) {
        this.m_Request.removeAttribute(theName);
    }

    public String getParameter(String theName) {
        return this.m_Request.getParameter(theName);
    }

    public String getServletPath() {
        if (this.m_URL != null) {
            return this.m_URL.getServletPath();
        }
        return this.m_Request.getServletPath();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_Request.isRequestedSessionIdFromCookie();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.m_Request.getInputStream();
    }

    public Principal getUserPrincipal() {
        return this.m_Request.getUserPrincipal();
    }

    public boolean isSecure() {
        return this.m_Request.isSecure();
    }

    public String getPathTranslated() {
        return this.m_Request.getPathTranslated();
    }

    public String getRemoteAddr() {
        return this.m_Request.getRemoteAddr();
    }

    public String getCharacterEncoding() {
        return this.m_Request.getCharacterEncoding();
    }

    public Enumeration getParameterNames() {
        return this.m_Request.getParameterNames();
    }

    public String getMethod() {
        return this.m_Request.getMethod();
    }

    public void setAttribute(String theName, Object theAttribute) {
        this.m_Request.setAttribute(theName, theAttribute);
    }

    public Object getAttribute(String theName) {
        return this.m_Request.getAttribute(theName);
    }

    public int getIntHeader(String theName) {
        return this.m_Request.getIntHeader(theName);
    }

    public boolean isRequestedSessionIdValid() {
        return this.m_Request.isRequestedSessionIdValid();
    }

    public String getQueryString() {
        if (this.m_URL != null) {
            return this.m_URL.getQueryString();
        }
        return this.m_Request.getQueryString();
    }

    public long getDateHeader(String theName) {
        return this.m_Request.getDateHeader(theName);
    }

    public Enumeration getAttributeNames() {
        return this.m_Request.getAttributeNames();
    }

    public String getRemoteUser() {
        return this.m_Request.getRemoteUser();
    }

    public String getProtocol() {
        return this.m_Request.getProtocol();
    }

    public Enumeration getHeaders(String theName) {
        return this.m_Request.getHeaders(theName);
    }

    public String getRequestedSessionId() {
        return this.m_Request.getRequestedSessionId();
    }

    public RequestDispatcher getRequestDispatcher(String thePath) {
        return this.m_Request.getRequestDispatcher(thePath);
    }

    public Cookie[] getCookies() {
        return this.m_Request.getCookies();
    }
}

