/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class ChangeLogTask
extends Task
implements ExecuteStreamHandler {
    private File m_UserConfigFile;
    private Properties m_UserList = new Properties();
    private File m_CVSWorkingDirectory;
    private File m_OutputFile;
    private Date m_ThresholdDate;
    private BufferedReader m_Input;
    private PrintWriter m_Output;
    private Vector m_Filesets = new Vector();
    private String m_TestURL = "http://jakarta.apache.org";
    private File m_DebugFile;
    private static final int GET_ENTRY = 0;
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final SimpleDateFormat INPUT_DATE = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat FULL_INPUT_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final SimpleDateFormat OUTPUT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat OUTPUT_TIME = new SimpleDateFormat("HH:mm");

    public void setUsers(File theUserConfigFileName) {
        this.m_UserConfigFile = theUserConfigFileName;
    }

    public void setWork(File theWorkDir) {
        this.m_CVSWorkingDirectory = theWorkDir;
    }

    public void setOutput(File theOutputFile) {
        this.m_OutputFile = theOutputFile;
    }

    public void setDate(String theThresholdDate) {
        try {
            this.m_ThresholdDate = INPUT_DATE.parse(theThresholdDate);
        }
        catch (ParseException e) {
            throw new BuildException("Bad date format [" + theThresholdDate + "].");
        }
    }

    public void setElapsed(Long theElapsedDays) {
        long now = System.currentTimeMillis();
        this.m_ThresholdDate = new Date(now - theElapsedDays * 24L * 60L * 60L * 1000L);
    }

    public void addFileset(FileSet theSet) {
        this.m_Filesets.addElement(theSet);
    }

    public void setTestURL(String theURLString) {
        this.m_TestURL = theURLString;
    }

    public void setDebug(File theDebugFile) {
        this.m_DebugFile = theDebugFile;
    }

    private void readUserList() {
        if (this.m_UserConfigFile != null) {
            if (!this.m_UserConfigFile.exists()) {
                throw new BuildException("User list configuration file [" + this.m_UserConfigFile.getAbsolutePath() + "] was not found. Please check location.");
            }
            try {
                this.m_UserList.load(new FileInputStream(this.m_UserConfigFile));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private boolean testInternetAccess() throws BuildException {
        try {
            URL url = new URL(this.m_TestURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            throw new BuildException("Bad URL [" + this.m_TestURL + "]");
        }
        catch (IOException e) {
            if (!this.m_OutputFile.exists()) {
                try {
                    this.m_Output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_OutputFile), "UTF-8"));
                    this.m_Output.println("<changelog>");
                    this.m_Output.println("</changelog>");
                    this.m_Output.flush();
                    this.m_Output.close();
                }
                catch (IOException ee) {
                    throw new BuildException((Throwable)ee);
                }
            }
            return false;
        }
        return true;
    }

    public void execute() throws BuildException {
        if (this.m_CVSWorkingDirectory == null) {
            throw new BuildException("The [workDir] attribute must be set");
        }
        if (!this.m_CVSWorkingDirectory.exists()) {
            throw new BuildException("Cannot find CVS working directory [" + this.m_CVSWorkingDirectory.getAbsolutePath() + "]");
        }
        if (this.m_OutputFile == null) {
            throw new BuildException("The [output] attribute must be set");
        }
        this.readUserList();
        if (!this.testInternetAccess()) {
            return;
        }
        Commandline toExecute = new Commandline();
        toExecute.setExecutable("cvs");
        toExecute.createArgument().setValue("log");
        if (this.m_ThresholdDate != null) {
            toExecute.createArgument().setValue("-d\">=" + OUTPUT_DATE.format(this.m_ThresholdDate) + "\"");
        }
        if (!this.m_Filesets.isEmpty()) {
            Enumeration e = this.m_Filesets.elements();
            while (e.hasMoreElements()) {
                FileSet fs = (FileSet)e.nextElement();
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                String[] srcFiles = ds.getIncludedFiles();
                int i = 0;
                while (i < srcFiles.length) {
                    toExecute.createArgument().setValue(srcFiles[i]);
                    ++i;
                }
            }
        }
        Execute exe = new Execute((ExecuteStreamHandler)this);
        exe.setCommandline(toExecute.getCommandline());
        exe.setAntRun(this.project);
        exe.setWorkingDirectory(this.m_CVSWorkingDirectory);
        try {
            exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setProcessInputStream(OutputStream theOs) throws IOException {
    }

    public void setProcessErrorStream(InputStream theIs) throws IOException {
    }

    public void setProcessOutputStream(InputStream theIs) throws IOException {
        this.m_Input = new BufferedReader(new InputStreamReader(theIs));
    }

    public void stop() {
    }

    public void start() throws IOException {
        this.m_Output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_OutputFile), "UTF-8"));
        PrintWriter debug = null;
        if (this.m_DebugFile != null) {
            debug = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_DebugFile), "UTF-8"));
        }
        String file = null;
        String line = null;
        String date = null;
        String author = null;
        String comment = null;
        String revision = null;
        int status = 1;
        Hashtable<String, Entry> entries = new Hashtable<String, Entry>();
        while ((line = this.m_Input.readLine()) != null) {
            if (debug != null) {
                debug.println(line);
                this.log(line);
            }
            switch (status) {
                case 1: {
                    if (!line.startsWith("Working file:")) break;
                    file = line.substring(14, line.length());
                    status = 4;
                    break;
                }
                case 4: {
                    if (line.startsWith("revision")) {
                        revision = line.substring(9);
                        status = 2;
                        break;
                    }
                    if (!line.startsWith("======")) break;
                    status = 1;
                    break;
                }
                case 2: {
                    if (!line.startsWith("date:")) break;
                    date = line.substring(6, 22);
                    line = line.substring(line.indexOf(";") + 1);
                    author = line.substring(10, line.indexOf(";"));
                    if (this.m_UserList != null && ((Hashtable)this.m_UserList).containsKey(author)) {
                        author = "<![CDATA[" + this.m_UserList.getProperty(author) + "]]>";
                    }
                    status = 3;
                    break;
                }
                case 3: {
                    Entry entry;
                    comment = "";
                    while (line != null && !line.startsWith("======") && !line.startsWith("------")) {
                        comment = comment + line + "\n";
                        line = this.m_Input.readLine();
                        if (debug == null) continue;
                        debug.println(line);
                        this.log(line);
                    }
                    comment = "<![CDATA[" + comment.substring(0, comment.length() - 1) + "]]>";
                    if (!entries.containsKey(date + author + comment)) {
                        entry = new Entry(date, author, comment);
                        entries.put(date + author + comment, entry);
                    } else {
                        entry = (Entry)entries.get(date + author + comment);
                    }
                    entry.addFile(file, revision);
                    status = line.startsWith("======") ? 1 : 4;
                }
            }
        }
        this.m_Output.println("<changelog>");
        Enumeration en = entries.elements();
        while (en.hasMoreElements()) {
            ((Entry)en.nextElement()).print();
        }
        this.m_Output.println("</changelog>");
        this.m_Output.flush();
        this.m_Output.close();
        if (debug != null) {
            debug.flush();
            debug.close();
        }
    }

    private class Entry {
        private Date m_Date;
        private final String m_Author;
        private final String m_Comment;
        private final Vector m_Files = new Vector();

        public Entry(String theDate, String theAuthor, String theComment) {
            try {
                this.m_Date = FULL_INPUT_DATE.parse(theDate);
            }
            catch (ParseException e) {
                ChangeLogTask.this.log("Bad date format [" + theDate + "].");
            }
            this.m_Author = theAuthor;
            this.m_Comment = theComment;
        }

        public void addFile(String theFile, String theRevision) {
            this.m_Files.addElement(new RCSFile(theFile, theRevision));
        }

        public String toString() {
            return this.m_Author + "\n" + this.m_Date + "\n" + this.m_Files + "\n" + this.m_Comment;
        }

        public void print() {
            ChangeLogTask.this.m_Output.println("\t<entry>");
            ChangeLogTask.this.m_Output.println("\t\t<date>" + OUTPUT_DATE.format(this.m_Date) + "</date>");
            ChangeLogTask.this.m_Output.println("\t\t<time>" + OUTPUT_TIME.format(this.m_Date) + "</time>");
            ChangeLogTask.this.m_Output.println("\t\t<author>" + this.m_Author + "</author>");
            Enumeration e = this.m_Files.elements();
            while (e.hasMoreElements()) {
                RCSFile file = (RCSFile)e.nextElement();
                ChangeLogTask.this.m_Output.println("\t\t<file>");
                ChangeLogTask.this.m_Output.println("\t\t\t<name>" + file.getName() + "</name>");
                ChangeLogTask.this.m_Output.println("\t\t\t<revision>" + file.getRevision() + "</revision>");
                ChangeLogTask.this.m_Output.println("\t\t</file>");
            }
            ChangeLogTask.this.m_Output.println("\t\t<msg>" + this.m_Comment + "</msg>");
            ChangeLogTask.this.m_Output.println("\t</entry>");
        }

        private class RCSFile {
            private String m_Name;
            private String m_Rev;

            private RCSFile(String theName, String theRev) {
                this.m_Name = theName;
                this.m_Rev = theRev;
            }

            public String getName() {
                return this.m_Name;
            }

            public String getRevision() {
                return this.m_Rev;
            }
        }
    }
}

