/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus.ant;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class ResinRun
extends Thread {
    private Object m_Server;
    private int m_Port = 7777;

    public static void main(String[] args) {
        ResinRun run = new ResinRun();
        boolean isStart = true;
        Vector<String> newArgs = new Vector<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-start")) {
                isStart = true;
            } else if (args[i].equalsIgnoreCase("-stop")) {
                isStart = false;
            } else if (args[i].equalsIgnoreCase("-port")) {
                run.m_Port = Integer.parseInt(args[i + 1]);
                ++i;
            } else {
                newArgs.add(args[i]);
            }
            ++i;
        }
        if (isStart) {
            String[] strArgs = new String[]{};
            run.startResin(newArgs.toArray(strArgs));
        } else {
            run.stopResin();
        }
    }

    private void startResin(String[] args) {
        if (this.m_Server == null) {
            try {
                Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
                Constructor<?> constructor = resinClass.getConstructor(args.getClass(), Boolean.TYPE);
                this.m_Server = constructor.newInstance(args, new Boolean(true));
                Method initMethod = resinClass.getMethod("init", Boolean.TYPE);
                initMethod.invoke(this.m_Server, new Boolean(true));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error starting Resin");
            }
        }
        new Thread(this).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopResin() {
        Socket clientSocket = null;
        try {
            try {
                clientSocket = new Socket("127.0.0.1", this.m_Port);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error opening socket tp 127.0.0.1 on port [" + this.m_Port + "]");
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (clientSocket == null) throw throwable;
                clientSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close client socket");
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException("Cannot close client socket");
        }
        if (clientSocket == null) return;
        clientSocket.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServerSocket serverSocket = this.setUpListenerSocket();
        Socket clientSocket = null;
        try {
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                throw new RuntimeException("Error accepting connection for server socket [" + serverSocket + "]");
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                serverSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
        }
        serverSocket.close();
        if (this.m_Server != null) {
            try {
                Method closeMethod = this.m_Server.getClass().getMethod("close", null);
                closeMethod.invoke(this.m_Server, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot stop Resin server");
            }
        }
        try {
            serverSocket.close();
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
        }
    }

    private ServerSocket setUpListenerSocket() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.m_Port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error setting up the Resin listener socket");
        }
        return serverSocket;
    }
}

