/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import junit.framework.AssertionFailedError;
import org.apache.commons.cactus.ServletTestRequest;

public class ServletURL {
    public static final String URL_SERVER_NAME_PARAM = "ServletTestCase_URL_Server";
    public static final String URL_CONTEXT_PATH_PARAM = "ServletTestCase_URL_ContextPath";
    public static final String URL_SERVLET_PATH_PARAM = "ServletTestCase_URL_ServletPath";
    public static final String URL_PATH_INFO_PARAM = "ServletTestCase_URL_PathInfo";
    public static final String URL_QUERY_STRING_PARAM = "ServletTestCase_URL_QueryString";
    private String m_URL_ServerName;
    private String m_URL_ContextPath;
    private String m_URL_ServletPath;
    private String m_URL_PathInfo;
    private String m_URL_QueryString;
    private URL m_FullURL;

    public ServletURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        if (theServerName == null) {
            throw new AssertionFailedError("Bad URL. The server name cannot be null");
        }
        this.m_URL_ServerName = theServerName;
        this.m_URL_ContextPath = theContextPath == null ? "" : theContextPath;
        this.m_URL_ServletPath = theServletPath;
        this.m_URL_PathInfo = thePathInfo;
        this.m_URL_QueryString = theQueryString;
        String fullURL = "http://" + this.m_URL_ServerName;
        if (this.m_URL_ContextPath.length() != 0) {
            fullURL = fullURL + this.m_URL_ContextPath;
        }
        if (this.m_URL_ServletPath != null && this.m_URL_ServletPath.length() != 0) {
            fullURL = fullURL + this.m_URL_ServletPath;
        }
        if (this.m_URL_PathInfo != null && this.m_URL_PathInfo.length() != 0) {
            fullURL = fullURL + this.m_URL_PathInfo;
        }
        try {
            this.m_FullURL = new URL(fullURL);
        }
        catch (MalformedURLException e) {
            throw new AssertionFailedError("Bad URL [" + fullURL + "]");
        }
    }

    public URL getURL() {
        return this.m_FullURL;
    }

    public String getServerName() {
        return this.m_URL_ServerName;
    }

    public String getContextPath() {
        return this.m_URL_ContextPath;
    }

    public String getServletPath() {
        return this.m_URL_ServletPath;
    }

    public String getPathInfo() {
        return this.m_URL_PathInfo;
    }

    public String getQueryString() {
        return this.m_URL_QueryString;
    }

    public void saveToRequest(ServletTestRequest theRequest) {
        if (this.m_URL_ServerName != null) {
            theRequest.addParameter(URL_SERVER_NAME_PARAM, this.getServerName());
        }
        if (this.m_URL_ContextPath != null) {
            theRequest.addParameter(URL_CONTEXT_PATH_PARAM, this.getContextPath());
        }
        if (this.m_URL_ServletPath != null) {
            theRequest.addParameter(URL_SERVLET_PATH_PARAM, this.getServletPath());
        }
        if (this.m_URL_PathInfo != null) {
            theRequest.addParameter(URL_PATH_INFO_PARAM, this.getPathInfo());
        }
        if (this.m_URL_QueryString != null) {
            theRequest.addParameter(URL_QUERY_STRING_PARAM, this.getQueryString());
        }
    }

    public static ServletURL loadFromRequest(HttpServletRequest theRequest) {
        String serverName = theRequest.getParameter(URL_SERVER_NAME_PARAM);
        String contextPath = theRequest.getParameter(URL_CONTEXT_PATH_PARAM);
        String servletPath = theRequest.getParameter(URL_SERVLET_PATH_PARAM);
        String pathInfo = theRequest.getParameter(URL_PATH_INFO_PARAM);
        String queryString = theRequest.getParameter(URL_QUERY_STRING_PARAM);
        if (serverName != null) {
            return new ServletURL(serverName, contextPath, servletPath, pathInfo, queryString);
        }
        return null;
    }
}

