/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.cactus.ServletURL;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private HttpServletRequest m_Request;
    private ServletURL m_URL;

    public HttpServletRequestWrapper(HttpServletRequest theRequest, ServletURL theURL) {
        this.m_Request = theRequest;
        this.m_URL = theURL;
    }

    public HttpServletRequest getOriginalRequest() {
        return this.m_Request;
    }

    public boolean isUserInRole(String theRole) {
        return this.m_Request.isUserInRole(theRole);
    }

    public boolean isRequestedSessionIdValid() {
        return this.m_Request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.m_Request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.m_Request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_Request.isRequestedSessionIdFromCookie();
    }

    public Principal getUserPrincipal() {
        return this.m_Request.getUserPrincipal();
    }

    public HttpSession getSession(boolean isCreate) {
        return this.m_Request.getSession(isCreate);
    }

    public HttpSession getSession() {
        return this.m_Request.getSession();
    }

    public String getServletPath() {
        if (this.m_URL != null) {
            return this.m_URL.getServletPath();
        }
        return this.m_Request.getServletPath();
    }

    public String getRequestedSessionId() {
        return this.m_Request.getRequestedSessionId();
    }

    public StringBuffer getRequestURL() {
        return this.m_Request.getRequestURL();
    }

    public String getRequestURI() {
        if (this.m_URL != null) {
            return this.m_URL.getURL().getFile();
        }
        return this.m_Request.getRequestURI();
    }

    public String getRemoteUser() {
        return this.m_Request.getRemoteUser();
    }

    public String getQueryString() {
        if (this.m_URL != null) {
            return this.m_URL.getQueryString();
        }
        return this.m_Request.getQueryString();
    }

    public String getPathTranslated() {
        return this.m_Request.getPathTranslated();
    }

    public String getPathInfo() {
        if (this.m_URL != null) {
            return this.m_URL.getPathInfo();
        }
        return this.m_Request.getPathInfo();
    }

    public String getMethod() {
        return this.m_Request.getMethod();
    }

    public int getIntHeader(String theName) {
        return this.m_Request.getIntHeader(theName);
    }

    public Enumeration getHeaders(String theName) {
        return this.m_Request.getHeaders(theName);
    }

    public Enumeration getHeaderNames() {
        return this.m_Request.getHeaderNames();
    }

    public String getHeader(String theName) {
        return this.m_Request.getHeader(theName);
    }

    public long getDateHeader(String theName) {
        return this.m_Request.getDateHeader(theName);
    }

    public Cookie[] getCookies() {
        return this.m_Request.getCookies();
    }

    public String getContextPath() {
        if (this.m_URL != null) {
            return this.m_URL.getContextPath();
        }
        return this.m_Request.getContextPath();
    }

    public String getAuthType() {
        return this.m_Request.getAuthType();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.m_Request.setCharacterEncoding(env);
    }

    public void setAttribute(String theName, Object theAttribute) {
        this.m_Request.setAttribute(theName, theAttribute);
    }

    public void removeAttribute(String theName) {
        this.m_Request.removeAttribute(theName);
    }

    public boolean isSecure() {
        return this.m_Request.isSecure();
    }

    public int getServerPort() {
        if (this.m_URL != null) {
            if (this.m_URL.getURL().getPort() == -1) {
                return 80;
            }
            return this.m_URL.getURL().getPort();
        }
        return this.m_Request.getServerPort();
    }

    public String getServerName() {
        if (this.m_URL != null) {
            return this.m_URL.getURL().getHost();
        }
        return this.m_Request.getServerName();
    }

    public String getScheme() {
        return this.m_Request.getScheme();
    }

    public RequestDispatcher getRequestDispatcher(String thePath) {
        return this.m_Request.getRequestDispatcher(thePath);
    }

    public String getRemoteHost() {
        return this.m_Request.getRemoteHost();
    }

    public String getRemoteAddr() {
        return this.m_Request.getRemoteAddr();
    }

    public String getRealPath(String thePath) {
        return this.m_Request.getRealPath(thePath);
    }

    public BufferedReader getReader() throws IOException {
        return this.m_Request.getReader();
    }

    public String getProtocol() {
        return this.m_Request.getProtocol();
    }

    public String[] getParameterValues(String theName) {
        return this.m_Request.getParameterValues(theName);
    }

    public Enumeration getParameterNames() {
        return this.m_Request.getParameterNames();
    }

    public Map getParameterMap() {
        return this.m_Request.getParameterMap();
    }

    public String getParameter(String theName) {
        return this.m_Request.getParameter(theName);
    }

    public Enumeration getLocales() {
        return this.m_Request.getLocales();
    }

    public Locale getLocale() {
        return this.m_Request.getLocale();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.m_Request.getInputStream();
    }

    public String getContentType() {
        return this.m_Request.getContentType();
    }

    public int getContentLength() {
        return this.m_Request.getContentLength();
    }

    public String getCharacterEncoding() {
        return this.m_Request.getCharacterEncoding();
    }

    public Enumeration getAttributeNames() {
        return this.m_Request.getAttributeNames();
    }

    public Object getAttribute(String theName) {
        return this.m_Request.getAttribute(theName);
    }
}

