/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cactus.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.cactus.server.ServletContextWrapper;

public class ServletConfigWrapper
implements ServletConfig {
    private ServletConfig m_OriginalConfig;
    private Hashtable m_InitParameters;
    private String m_ServletName;

    public ServletConfigWrapper(ServletConfig theOriginalConfig) {
        this.m_OriginalConfig = theOriginalConfig;
        this.m_InitParameters = new Hashtable();
    }

    public void setInitParameter(String theName, String theValue) {
        this.m_InitParameters.put(theName, theValue);
    }

    public void setServletName(String theServletName) {
        this.m_ServletName = theServletName;
    }

    public String getServletName() {
        if (this.m_ServletName != null) {
            return this.m_ServletName;
        }
        return this.m_OriginalConfig.getServletName();
    }

    public ServletContext getServletContext() {
        return new ServletContextWrapper(this.m_OriginalConfig.getServletContext());
    }

    public Enumeration getInitParameterNames() {
        String value;
        Vector<String> names = new Vector<String>();
        Enumeration enumeration = this.m_InitParameters.keys();
        while (enumeration.hasMoreElements()) {
            value = (String)enumeration.nextElement();
            names.add(value);
        }
        enumeration = this.m_OriginalConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            value = (String)enumeration.nextElement();
            names.add(value);
        }
        return names.elements();
    }

    public String getInitParameter(String theName) {
        String value = (String)this.m_InitParameters.get(theName);
        if (value == null) {
            value = this.m_OriginalConfig.getInitParameter(theName);
        }
        return value;
    }
}

