/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.ftp;

import com.oroinc.io.FromNetASCIIInputStream;
import com.oroinc.io.SocketInputStream;
import com.oroinc.io.SocketOutputStream;
import com.oroinc.io.ToNetASCIIOutputStream;
import com.oroinc.io.Util;
import com.oroinc.net.MalformedServerReplyException;
import com.oroinc.net.ftp.DefaultFTPFileListParser;
import com.oroinc.net.ftp.FTP;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPFileListParser;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class FTPClient
extends FTP {
    public static final int ACTIVE_LOCAL_DATA_CONNECTION_MODE = 0;
    public static final int ACTIVE_REMOTE_DATA_CONNECTION_MODE = 1;
    public static final int PASSIVE_LOCAL_DATA_CONNECTION_MODE = 2;
    public static final int PASSIVE_REMOTE_DATA_CONNECTION_MODE = 3;
    private int __dataConnectionMode;
    private int __dataTimeout;
    private int __passivePort;
    private String __passiveHost;
    private int __fileType;
    private int __fileFormat;
    private int __fileStructure;
    private int __fileTransferMode;
    private boolean __remoteVerificationEnabled;
    private FTPFileListParser __fileListParser;

    public FTPClient() {
        this.__initDefaults();
        this.__fileListParser = new DefaultFTPFileListParser();
        this.__dataTimeout = -1;
        this.__remoteVerificationEnabled = true;
    }

    private void __initDefaults() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
        this.__fileType = 0;
        this.__fileStructure = 7;
        this.__fileFormat = 4;
        this.__fileTransferMode = 10;
    }

    private String __parsePathname(String string) {
        int n = string.indexOf(34) + 1;
        int n2 = string.indexOf(34, n);
        return string.substring(n, n2);
    }

    private void __parsePassiveModeReply(String string) throws MalformedServerReplyException {
        string = string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim();
        StringBuffer stringBuffer = new StringBuffer(24);
        int n = 0;
        int n2 = string.indexOf(44);
        stringBuffer.append(string.substring(n, n2));
        int n3 = 0;
        while (n3 < 3) {
            stringBuffer.append('.');
            n = n2 + 1;
            n2 = string.indexOf(44, n);
            stringBuffer.append(string.substring(n, n2));
            ++n3;
        }
        n = n2 + 1;
        n2 = string.indexOf(44, n);
        String string2 = string.substring(n, n2);
        String string3 = string.substring(n2 + 1);
        try {
            n2 = Integer.parseInt(string2);
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + string);
        }
        n2 <<= 8;
        this.__passiveHost = stringBuffer.toString();
        this.__passivePort = n2 |= n;
    }

    private Socket __openDataConnection(int n, String string) throws IOException {
        Socket socket;
        Object object;
        if (this.__dataConnectionMode != 0 && this.__dataConnectionMode != 2) {
            return null;
        }
        if (this.__dataConnectionMode == 0) {
            object = this._socketFactory_.createServerSocket(0, 1, this.getLocalAddress());
            if (!FTPReply.isPositiveCompletion(this.port(this.getLocalAddress(), ((ServerSocket)object).getLocalPort()))) {
                ((ServerSocket)object).close();
                return null;
            }
            if (!FTPReply.isPositivePreliminary(this.sendCommand(n, string))) {
                ((ServerSocket)object).close();
                return null;
            }
            if (this.__dataTimeout >= 0) {
                ((ServerSocket)object).setSoTimeout(this.__dataTimeout);
            }
            socket = ((ServerSocket)object).accept();
            ((ServerSocket)object).close();
        } else {
            if (this.pasv() != 227) {
                return null;
            }
            this.__parsePassiveModeReply((String)this._replyLines.elementAt(0));
            socket = this._socketFactory_.createSocket(this.__passiveHost, this.__passivePort);
            if (!FTPReply.isPositivePreliminary(this.sendCommand(n, string))) {
                socket.close();
                return null;
            }
        }
        if (this.__remoteVerificationEnabled && !this.verifyRemote(socket)) {
            object = socket.getInetAddress();
            InetAddress inetAddress = this.getRemoteAddress();
            socket.close();
            throw new IOException("Host attempting data connection " + ((InetAddress)object).getHostAddress() + " is not same as server " + inetAddress.getHostAddress());
        }
        if (this.__dataTimeout >= 0) {
            socket.setSoTimeout(this.__dataTimeout);
        }
        return socket;
    }

    private boolean __storeFile(int n, String string, InputStream inputStream) throws IOException {
        Socket socket = this.__openDataConnection(n, string);
        if (socket == null) {
            return false;
        }
        FilterOutputStream filterOutputStream = new BufferedOutputStream(socket.getOutputStream());
        if (this.__fileType == 0) {
            filterOutputStream = new ToNetASCIIOutputStream(filterOutputStream);
        }
        try {
            Util.copyStream(inputStream, filterOutputStream);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
        ((OutputStream)filterOutputStream).close();
        socket.close();
        return this.completePendingCommand();
    }

    private OutputStream __storeFileStream(int n, String string) throws IOException {
        Socket socket = this.__openDataConnection(n, string);
        if (socket == null) {
            return null;
        }
        OutputStream outputStream = socket.getOutputStream();
        if (this.__fileType == 0) {
            outputStream = new ToNetASCIIOutputStream(outputStream);
        }
        return new SocketOutputStream(socket, outputStream);
    }

    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this.__initDefaults();
    }

    public void setDataTimeout(int n) {
        this.__dataTimeout = n;
    }

    public void disconnect() throws IOException {
        super.disconnect();
        this.__initDefaults();
    }

    public void setRemoteVerificationEnabled(boolean bl) {
        this.__remoteVerificationEnabled = bl;
    }

    public boolean isRemoteVerificationEnabled() {
        return this.__remoteVerificationEnabled;
    }

    public boolean login(String string, String string2) throws IOException {
        this.user(string);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.pass(string2));
    }

    public boolean login(String string, String string2, String string3) throws IOException {
        this.user(string);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        this.pass(string2);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.acct(string3));
    }

    public boolean logout() throws IOException {
        return FTPReply.isPositiveCompletion(this.quit());
    }

    public boolean changeWorkingDirectory(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.cwd(string));
    }

    public boolean changeToParentDirectory() throws IOException {
        return FTPReply.isPositiveCompletion(this.cdup());
    }

    public boolean structureMount(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.smnt(string));
    }

    boolean reinitialize() throws IOException {
        this.rein();
        if (FTPReply.isPositiveCompletion(this._replyCode) || FTPReply.isPositivePreliminary(this._replyCode) && FTPReply.isPositiveCompletion(this.getReply())) {
            this.__initDefaults();
            return true;
        }
        return false;
    }

    public void enterLocalActiveMode() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public void enterLocalPassiveMode() {
        this.__dataConnectionMode = 2;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public boolean enterRemoteActiveMode(InetAddress inetAddress, int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.port(inetAddress, n))) {
            this.__dataConnectionMode = 1;
            this.__passiveHost = null;
            this.__passivePort = -1;
            return true;
        }
        return false;
    }

    public boolean enterRemotePassiveMode() throws IOException {
        if (this.pasv() != 227) {
            return false;
        }
        this.__dataConnectionMode = 3;
        this.__parsePassiveModeReply((String)this._replyLines.elementAt(0));
        return true;
    }

    public String getPassiveHost() {
        return this.__passiveHost;
    }

    public int getPassivePort() {
        return this.__passivePort;
    }

    public int getDataConnectionMode() {
        return this.__dataConnectionMode;
    }

    public boolean setFileType(int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.type(n))) {
            this.__fileType = n;
            this.__fileFormat = 4;
            return true;
        }
        return false;
    }

    public boolean setFileType(int n, int n2) throws IOException {
        if (FTPReply.isPositiveCompletion(this.type(n, n2))) {
            this.__fileType = n;
            this.__fileFormat = n2;
            return true;
        }
        return false;
    }

    public boolean setFileStructure(int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.stru(n))) {
            this.__fileStructure = n;
            return true;
        }
        return false;
    }

    public boolean setFileTransferMode(int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.mode(n))) {
            this.__fileTransferMode = n;
            return true;
        }
        return false;
    }

    public boolean remoteRetrieve(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.retr(string));
        }
        return false;
    }

    public boolean remoteStore(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stor(string));
        }
        return false;
    }

    public boolean remoteStoreUnique(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stou(string));
        }
        return false;
    }

    public boolean remoteStoreUnique() throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stou());
        }
        return false;
    }

    public boolean remoteAppend(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stor(string));
        }
        return false;
    }

    public boolean completePendingCommand() throws IOException {
        return FTPReply.isPositiveCompletion(this.getReply());
    }

    public boolean retrieveFile(String string, OutputStream outputStream) throws IOException {
        Socket socket = this.__openDataConnection(13, string);
        if (socket == null) {
            return false;
        }
        FilterInputStream filterInputStream = new BufferedInputStream(socket.getInputStream());
        if (this.__fileType == 0) {
            filterInputStream = new FromNetASCIIInputStream(filterInputStream);
        }
        try {
            Util.copyStream(filterInputStream, outputStream);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
        socket.close();
        return this.completePendingCommand();
    }

    public InputStream retrieveFileStream(String string) throws IOException {
        Socket socket = this.__openDataConnection(13, string);
        if (socket == null) {
            return null;
        }
        InputStream inputStream = socket.getInputStream();
        if (this.__fileType == 0) {
            inputStream = new FromNetASCIIInputStream(inputStream);
        }
        return new SocketInputStream(socket, inputStream);
    }

    public boolean storeFile(String string, InputStream inputStream) throws IOException {
        return this.__storeFile(14, string, inputStream);
    }

    public OutputStream storeFileStream(String string) throws IOException {
        return this.__storeFileStream(14, string);
    }

    public boolean appendFile(String string, InputStream inputStream) throws IOException {
        return this.__storeFile(16, string, inputStream);
    }

    public OutputStream appendFileStream(String string) throws IOException {
        return this.__storeFileStream(16, string);
    }

    public boolean storeUniqueFile(String string, InputStream inputStream) throws IOException {
        return this.__storeFile(15, string, inputStream);
    }

    public OutputStream storeUniqueFileStream(String string) throws IOException {
        return this.__storeFileStream(15, string);
    }

    public boolean storeUniqueFile(InputStream inputStream) throws IOException {
        return this.__storeFile(15, null, inputStream);
    }

    public OutputStream storeUniqueFileStream() throws IOException {
        return this.__storeFileStream(15, null);
    }

    public boolean allocate(int n) throws IOException {
        return FTPReply.isPositiveCompletion(this.allo(n));
    }

    public boolean allocate(int n, int n2) throws IOException {
        return FTPReply.isPositiveCompletion(this.allo(n, n2));
    }

    public boolean restart(long l) throws IOException {
        return FTPReply.isPositiveIntermediate(this.rest(Long.toString(l)));
    }

    public boolean rename(String string, String string2) throws IOException {
        if (!FTPReply.isPositiveIntermediate(this.rnfr(string))) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.rnto(string2));
    }

    public boolean abort() throws IOException {
        return FTPReply.isPositiveCompletion(this.abor());
    }

    public boolean deleteFile(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.dele(string));
    }

    public boolean removeDirectory(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.rmd(string));
    }

    public boolean makeDirectory(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.mkd(string));
    }

    public String printWorkingDirectory() throws IOException {
        if (this.pwd() != 257) {
            return null;
        }
        return this.__parsePathname((String)this._replyLines.elementAt(0));
    }

    public boolean sendSiteCommand(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.site(string));
    }

    public String getSystemName() throws IOException {
        if (this.syst() == 215) {
            return ((String)this._replyLines.elementAt(0)).substring(4);
        }
        return null;
    }

    public String listHelp() throws IOException {
        if (FTPReply.isPositiveCompletion(this.help())) {
            return this.getReplyString();
        }
        return null;
    }

    public String listHelp(String string) throws IOException {
        if (FTPReply.isPositiveCompletion(this.help(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public boolean sendNoOp() throws IOException {
        return FTPReply.isPositiveCompletion(this.noop());
    }

    public String[] listNames(String string) throws IOException {
        String string2;
        Socket socket = this.__openDataConnection(27, string);
        if (socket == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        Vector<String> vector = new Vector<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            vector.addElement(string2);
        }
        bufferedReader.close();
        socket.close();
        if (this.completePendingCommand()) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String[] listNames() throws IOException {
        return this.listNames(null);
    }

    public FTPFile[] listFiles(FTPFileListParser fTPFileListParser, String string) throws IOException {
        Socket socket = this.__openDataConnection(26, string);
        if (socket == null) {
            return null;
        }
        FTPFile[] fTPFileArray = fTPFileListParser.parseFileList(socket.getInputStream());
        socket.close();
        this.completePendingCommand();
        return fTPFileArray;
    }

    public FTPFile[] listFiles(FTPFileListParser fTPFileListParser) throws IOException {
        return this.listFiles(fTPFileListParser, null);
    }

    public FTPFile[] listFiles(String string) throws IOException {
        return this.listFiles(this.__fileListParser, string);
    }

    public FTPFile[] listFiles() throws IOException {
        return this.listFiles(this.__fileListParser);
    }

    public String getStatus() throws IOException {
        if (FTPReply.isPositiveCompletion(this.stat())) {
            return this.getReplyString();
        }
        return null;
    }

    public String getStatus(String string) throws IOException {
        if (FTPReply.isPositiveCompletion(this.stat(string))) {
            return this.getReplyString();
        }
        return null;
    }
}

