/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemUse;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemLiteralResult
extends ElemUse {
    private boolean isLiteralResultAsStylesheet = false;
    private Vector m_avts = null;
    private Vector m_xslAttr = null;
    private String m_namespace;
    private String m_localName;
    private String m_rawName;
    private StringVector m_ExtensionElementURIs;
    private String m_version;
    private StringVector m_excludeResultPrefixes;

    public void addLiteralResultAttribute(String string) {
        if (this.m_xslAttr == null) {
            this.m_xslAttr = new Vector();
        }
        this.m_xslAttr.addElement(string);
    }

    public void addLiteralResultAttribute(AVT aVT) {
        if (this.m_avts == null) {
            this.m_avts = new Vector();
        }
        this.m_avts.addElement(aVT);
    }

    public boolean containsExcludeResultPrefix(String string) {
        if (this.m_excludeResultPrefixes == null) {
            return super.containsExcludeResultPrefix(string);
        }
        if (string.length() == 0) {
            string = "#default";
        }
        if (this.m_excludeResultPrefixes.contains(string)) {
            return true;
        }
        return super.containsExcludeResultPrefix(string);
    }

    public boolean containsExtensionElementURI(String string) {
        if (this.m_ExtensionElementURIs == null) {
            return false;
        }
        return this.m_ExtensionElementURIs.contains(string);
    }

    public Enumeration enumerateLiteralResultAttributes() {
        return this.m_avts == null ? null : this.m_avts.elements();
    }

    private boolean excludeResultNSDecl(String string, String string2) throws TransformerException {
        return this.m_excludeResultPrefixes != null && this.m_excludeResultPrefixes.contains(string);
    }

    public void execute(TransformerImpl transformerImpl, Node node, QName qName) throws TransformerException {
        try {
            ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
            this.executeNSDecls(transformerImpl);
            resultTreeHandler.startElement(this.getNamespace(), this.getLocalName(), this.getRawName());
            try {
                super.execute(transformerImpl, node, qName);
                if (this.m_avts != null) {
                    int n = this.m_avts.size();
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        XPathContext xPathContext;
                        AVT aVT = (AVT)this.m_avts.elementAt(n2);
                        String string = aVT.evaluate(xPathContext = transformerImpl.getXPathContext(), node, this);
                        if (string != null) {
                            resultTreeHandler.addAttribute(aVT.getURI(), aVT.getName(), aVT.getRawName(), "CDATA", string);
                        }
                        --n2;
                    }
                }
                transformerImpl.executeChildTemplates(this, node, qName);
                Object var6_12 = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                resultTreeHandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
                this.unexecuteNSDecls(transformerImpl);
                throw throwable;
            }
            resultTreeHandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
            this.unexecuteNSDecls(transformerImpl);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public String getExtensionElementPrefix(int n) throws ArrayIndexOutOfBoundsException {
        if (this.m_ExtensionElementURIs == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_ExtensionElementURIs.elementAt(n);
    }

    public int getExtensionElementPrefixCount() {
        return this.m_ExtensionElementURIs != null ? this.m_ExtensionElementURIs.size() : 0;
    }

    public boolean getIsLiteralResultAsStylesheet() {
        return this.isLiteralResultAsStylesheet;
    }

    public AVT getLiteralResultAttribute(String string) {
        if (this.m_avts != null) {
            int n = this.m_avts.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                AVT aVT = (AVT)this.m_avts.elementAt(n2);
                if (aVT.getRawName().equals(string)) {
                    return aVT;
                }
                --n2;
            }
        }
        return null;
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getNodeName() {
        return this.m_rawName;
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public int getXSLToken() {
        return 77;
    }

    boolean needToCheckExclude() {
        if (this.m_excludeResultPrefixes == null && this.m_prefixTable == null) {
            return false;
        }
        if (this.m_prefixTable == null) {
            this.m_prefixTable = new Vector();
        }
        return true;
    }

    public void resolvePrefixTables() throws TransformerException {
        NamespaceAlias namespaceAlias;
        super.resolvePrefixTables();
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        if (this.m_namespace != null && this.m_namespace.length() > 0 && (namespaceAlias = stylesheetRoot.getNamespaceAliasComposed(this.m_namespace)) != null) {
            this.m_namespace = namespaceAlias.getResultNamespace();
            String string = namespaceAlias.getStylesheetPrefix();
            this.m_rawName = string != null && string.length() > 0 ? String.valueOf(string) + ":" + this.m_localName : this.m_localName;
        }
        if (this.m_avts != null) {
            int n = this.m_avts.size();
            int n2 = 0;
            while (n2 < n) {
                NamespaceAlias namespaceAlias2;
                AVT aVT = (AVT)this.m_avts.elementAt(n2);
                String string = aVT.getURI();
                if (string != null && string.length() > 0 && (namespaceAlias2 = stylesheetRoot.getNamespaceAliasComposed(this.m_namespace)) != null) {
                    String string2 = namespaceAlias2.getResultNamespace();
                    String string3 = namespaceAlias2.getStylesheetPrefix();
                    String string4 = aVT.getName();
                    if (string3 != null && string3.length() > 0) {
                        string4 = String.valueOf(string3) + ":" + string4;
                    }
                    aVT.setURI(string2);
                    aVT.setRawName(string4);
                }
                ++n2;
            }
        }
    }

    public void setExcludeResultPrefixes(StringVector stringVector) {
        this.m_excludeResultPrefixes = stringVector;
    }

    public void setExtensionElementPrefixes(StringVector stringVector) {
        this.m_ExtensionElementURIs = stringVector;
    }

    public void setIsLiteralResultAsStylesheet(boolean bl) {
        this.isLiteralResultAsStylesheet = bl;
    }

    public void setLocalName(String string) {
        this.m_localName = string;
    }

    public void setNamespace(String string) {
        if (string == null) {
            string = "";
        }
        this.m_namespace = string;
    }

    public void setRawName(String string) {
        this.m_rawName = string;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public void setXmlSpace(AVT aVT) {
        this.addLiteralResultAttribute(aVT);
        String string = aVT.getSimpleString();
        if (string.equals("default")) {
            super.setXmlSpace(2);
        } else if (string.equals("preserve")) {
            super.setXmlSpace(1);
        }
    }
}

