/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PathTokenizer {
    private StringTokenizer tokenizer;
    private String lookahead = null;
    private boolean dosStyleFilesystem;

    public PathTokenizer(String string) {
        this.tokenizer = new StringTokenizer(string, ":;", false);
        this.dosStyleFilesystem = File.pathSeparatorChar == ';';
    }

    public boolean hasMoreTokens() {
        if (this.lookahead != null) {
            return true;
        }
        return this.tokenizer.hasMoreTokens();
    }

    public String nextToken() throws NoSuchElementException {
        String string = null;
        if (this.lookahead != null) {
            string = this.lookahead;
            this.lookahead = null;
        } else {
            string = this.tokenizer.nextToken().trim();
        }
        if (string.length() == 1 && Character.isLetter(string.charAt(0)) && this.dosStyleFilesystem && this.tokenizer.hasMoreTokens()) {
            String string2 = this.tokenizer.nextToken().trim();
            if (string2.startsWith("\\") || string2.startsWith("/")) {
                string = string + ":" + string2;
            } else {
                this.lookahead = string2;
            }
        }
        return string;
    }
}

