/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import com.sun.tools.javah.Main;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Javah
extends Task {
    private static final String FAIL_MSG = "Compile failed, messages should have been provided.";
    private Vector classes = new Vector(2);
    private String cls;
    private File destDir;
    private Path classpath = null;
    private String outputFile = null;
    private boolean verbose = false;
    private boolean force = false;
    private boolean old = false;
    private boolean stubs = false;
    private Path bootclasspath;
    private static String lSep = System.getProperty("line.separator");

    public void setClass(String string) {
        this.cls = string;
    }

    public ClassArgument createClass() {
        ClassArgument classArgument = new ClassArgument();
        this.classes.addElement(classArgument);
        return classArgument;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setOld(boolean bl) {
        this.old = bl;
    }

    public void setStubs(boolean bl) {
        this.stubs = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void execute() throws BuildException {
        String string;
        if (this.cls == null && this.classes.size() == 0) {
            throw new BuildException("class attribute must be set!", this.location);
        }
        if (this.cls != null && this.classes.size() > 0) {
            throw new BuildException("set class attribute or class element, not both.", this.location);
        }
        if (this.destDir != null) {
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.location);
            }
            if (this.outputFile != null) {
                throw new BuildException("destdir and outputFile are mutually exclusive", this.location);
            }
        }
        if (this.classpath == null) {
            this.classpath = Path.systemClasspath;
        }
        if ((string = this.project.getProperty("build.compiler")) == null) {
            string = Project.getJavaVersion().startsWith("1.3") ? "modern" : "classic";
        }
        this.doClassicCompile();
    }

    private void doClassicCompile() throws BuildException {
        Commandline commandline = this.setupJavahCommand();
        PrintStream printStream = System.err;
        PrintStream printStream2 = System.out;
        try {
            try {
                PrintStream printStream3 = new PrintStream((OutputStream)new LogOutputStream((Task)this, 1));
                System.setOut(printStream3);
                System.setErr(printStream3);
                Main main = new Main(commandline.getArguments());
                main.run();
            }
            catch (Exception exception) {
                if (exception instanceof BuildException) {
                    throw (BuildException)exception;
                }
                throw new BuildException("Error starting javah: ", (Throwable)exception, this.location);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            System.setErr(printStream);
            System.setOut(printStream2);
            throw throwable;
        }
        System.setErr(printStream);
        System.setOut(printStream2);
    }

    private Commandline setupJavahCommand() {
        Commandline commandline = new Commandline();
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
        }
        if (this.outputFile != null) {
            commandline.createArgument().setValue("-o");
            commandline.createArgument().setValue(this.outputFile);
        }
        if (this.classpath != null) {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setPath(this.classpath);
        }
        if (Project.getJavaVersion().startsWith("1.1")) {
            if (this.verbose) {
                commandline.createArgument().setValue("-v");
            }
        } else {
            if (this.verbose) {
                commandline.createArgument().setValue("-verbose");
            }
            if (this.old) {
                commandline.createArgument().setValue("-old");
            }
            if (this.force) {
                commandline.createArgument().setValue("-force");
            }
        }
        if (this.stubs) {
            if (!this.old) {
                throw new BuildException("stubs only available in old mode.", this.location);
            }
            commandline.createArgument().setValue("-stubs");
        }
        if (this.bootclasspath != null) {
            commandline.createArgument().setValue("-bootclasspath");
            commandline.createArgument().setPath(this.bootclasspath);
        }
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        Object object;
        StringTokenizer stringTokenizer;
        int n = 0;
        this.log("Compilation args: " + commandline.toString(), 3);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cls != null) {
            stringTokenizer = new StringTokenizer(this.cls, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                commandline.createArgument().setValue((String)object);
                stringBuffer.append("    " + (String)object + lSep);
                ++n;
            }
        }
        stringTokenizer = this.classes.elements();
        while (stringTokenizer.hasMoreElements()) {
            object = (ClassArgument)stringTokenizer.nextElement();
            String string = ((ClassArgument)object).getName();
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string + lSep);
            ++n;
        }
        object = new StringBuffer("Class");
        if (n > 1) {
            ((StringBuffer)object).append("es");
        }
        ((StringBuffer)object).append(" to be compiled:");
        ((StringBuffer)object).append(lSep);
        this.log(((StringBuffer)object).toString() + stringBuffer.toString(), 3);
    }

    public class ClassArgument {
        private String name;

        public void setName(String string) {
            this.name = string;
            Javah.this.log("ClassArgument.name=" + string);
        }

        public String getName() {
            return this.name;
        }
    }
}

