/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class PlainJUnitResultFormatter
implements JUnitResultFormatter {
    private NumberFormat nf = NumberFormat.getInstance();
    private long lastTestStart = 0L;
    private OutputStream out;
    private StringWriter inner = new StringWriter();
    private PrintWriter wri = new PrintWriter(this.inner);
    private boolean failed = true;

    public void setOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void startTestSuite(JUnitTest jUnitTest) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest jUnitTest) throws BuildException {
        StringBuffer stringBuffer = new StringBuffer("Testsuite: ");
        stringBuffer.append(jUnitTest.getName());
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("Tests run: ");
        stringBuffer.append(jUnitTest.runCount());
        stringBuffer.append(", Failures: ");
        stringBuffer.append(jUnitTest.failureCount());
        stringBuffer.append(", Errors: ");
        stringBuffer.append(jUnitTest.errorCount());
        stringBuffer.append(", Time elapsed: ");
        stringBuffer.append(this.nf.format((double)jUnitTest.getRunTime() / 1000.0));
        stringBuffer.append(" sec");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(System.getProperty("line.separator"));
        if (this.out == null) return;
        try {
            try {
                this.out.write(stringBuffer.toString().getBytes());
                this.wri.close();
                this.out.write(this.inner.toString().getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to write output", (Throwable)iOException);
            }
            Object var5_3 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.out.close();
        return;
    }

    public void startTest(Test test) {
        this.lastTestStart = System.currentTimeMillis();
        this.wri.print("Testcase: " + ((TestCase)test).name());
        this.failed = false;
    }

    public void endTest(Test test) {
        if (this.failed) {
            return;
        }
        this.wri.println(" took " + this.nf.format((double)(System.currentTimeMillis() - this.lastTestStart) / 1000.0) + " sec");
    }

    public void addFailure(Test test, Throwable throwable) {
        this.formatError("\tFAILED", test, throwable);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.addFailure(test, (Throwable)assertionFailedError);
    }

    public void addError(Test test, Throwable throwable) {
        this.formatError("\tCaused an ERROR", test, throwable);
    }

    private void formatError(String string, Test test, Throwable throwable) {
        if (test != null) {
            this.endTest(test);
        }
        this.failed = true;
        this.wri.println(string);
        this.wri.println(throwable.getMessage());
        throwable.printStackTrace(this.wri);
        this.wri.println("");
    }
}

